/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.utils;

import com.oheers.fish.messages.ConfigMessage;
import com.oheers.fish.messages.abstracted.EMFMessage;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.Period;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.JoinConfiguration;
import org.jetbrains.annotations.NotNull;

public record DurationFormatter(@NotNull TimeUnit timeUnit) {
    public Component format(long value) {
        long seconds = this.timeUnit.toSeconds(value);
        Duration duration = Duration.ofSeconds(seconds);
        LocalDateTime baseDate = LocalDateTime.now().minusSeconds(seconds);
        LocalDateTime now = LocalDateTime.now();
        Period period = Period.between(baseDate.toLocalDate(), now.toLocalDate());
        long days = period.getDays();
        long hours = duration.toHoursPart();
        long minutes = duration.toMinutesPart();
        long remainingSeconds = duration.toSecondsPart();
        ArrayList<Component> list = new ArrayList<Component>();
        DurationFormatter.appendUnit(list, days, Unit.DAY);
        DurationFormatter.appendUnit(list, hours, Unit.HOUR);
        DurationFormatter.appendUnit(list, minutes, Unit.MINUTE);
        DurationFormatter.appendUnit(list, remainingSeconds, Unit.SECOND);
        return Component.join((JoinConfiguration)JoinConfiguration.separator((ComponentLike)Component.space()), list);
    }

    private static void appendUnit(@NotNull List<Component> list, long value, @NotNull Unit timeUnit) {
        if (value <= 0L) {
            return;
        }
        list.add(timeUnit.getFormat(value).getComponentMessage());
    }

    private static enum Unit {
        DAY(ConfigMessage.DURATION_DAY::getMessage, "{day}"),
        HOUR(ConfigMessage.DURATION_HOUR::getMessage, "{hour}"),
        MINUTE(ConfigMessage.DURATION_MINUTE::getMessage, "{minute}"),
        SECOND(ConfigMessage.DURATION_SECOND::getMessage, "{second}");

        private final Supplier<EMFMessage> formatSupplier;
        private final String variable;

        private Unit(Supplier<EMFMessage> formatSupplier, String variable) {
            this.formatSupplier = formatSupplier;
            this.variable = variable;
        }

        public EMFMessage getFormat(long value) {
            EMFMessage message = this.formatSupplier.get();
            message.setVariable(this.variable, value);
            return message;
        }
    }
}

