/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.utils;

import com.oheers.fish.FishUtils;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAdjusters;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public record TimeCode(@NotNull String code) {
    public static TimeCode now() {
        return TimeCode.fromDateTime(LocalDateTime.now());
    }

    public static TimeCode fromDateTime(LocalDateTime time) {
        return TimeCode.exact(time.getDayOfWeek(), time.getHour(), time.getMinute());
    }

    public static TimeCode exact(@NotNull DayOfWeek day, @Range(from=0L, to=23L) int hour, @Range(from=0L, to=59L) int minute) {
        return new TimeCode(String.valueOf(day) + "-" + hour + "-" + minute);
    }

    public long toMillis() {
        String[] split = this.code.split("-");
        if (split.length != 3) {
            return -1L;
        }
        DayOfWeek day = FishUtils.getDay(split[0]);
        Integer hour = FishUtils.getInteger(split[1]);
        Integer minute = FishUtils.getInteger(split[2]);
        if (day == null || hour == null || minute == null) {
            return -1L;
        }
        LocalDate targetDay = LocalDate.now().with(TemporalAdjusters.nextOrSame(day));
        LocalDateTime exactTime = targetDay.atTime(hour, minute);
        ZonedDateTime zoned = exactTime.atZone(ZoneId.systemDefault());
        return zoned.toInstant().toEpochMilli();
    }

    public Long toMillisNullable() {
        long millis = this.toMillis();
        if (millis == -1L) {
            return null;
        }
        return millis;
    }

    public static Comparator<TimeCode> getComparator() {
        return Comparator.comparingLong(TimeCode::toMillis);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TimeCode)) {
            return false;
        }
        TimeCode other = (TimeCode)obj;
        return other.code.equals(this.code);
    }

    @Override
    @NotNull
    public String toString() {
        return this.code;
    }
}

