/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish;

import com.oheers.fish.Toggle;
import com.oheers.fish.api.EMFAPI;
import com.oheers.fish.api.economy.Economy;
import com.oheers.fish.api.plugin.EMFPlugin;
import com.oheers.fish.baits.manager.BaitManager;
import com.oheers.fish.competition.AutoRunner;
import com.oheers.fish.competition.Competition;
import com.oheers.fish.competition.CompetitionQueue;
import com.oheers.fish.config.MainConfig;
import com.oheers.fish.events.FishInteractEvent;
import com.oheers.fish.events.McMMOTreasureEvent;
import com.oheers.fish.fishing.items.FishManager;
import com.oheers.fish.fishing.items.Rarity;
import com.oheers.fish.fishing.rods.RodManager;
import com.oheers.fish.libs.inventorygui.InventoryGui;
import com.oheers.fish.libs.universalScheduler.UniversalScheduler;
import com.oheers.fish.libs.universalScheduler.scheduling.schedulers.TaskScheduler;
import com.oheers.fish.messages.ConfigMessage;
import com.oheers.fish.plugin.ConfigurationManager;
import com.oheers.fish.plugin.DependencyManager;
import com.oheers.fish.plugin.EventManager;
import com.oheers.fish.plugin.IntegrationManager;
import com.oheers.fish.plugin.MetricsManager;
import com.oheers.fish.plugin.PluginDataManager;
import com.oheers.fish.update.UpdateChecker;
import com.oheers.fish.utils.nbtapi.NBT;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EvenMoreFish
extends EMFPlugin {
    private final Random random = ThreadLocalRandom.current();
    private final Toggle toggle;
    private boolean raritiesCompCheckExempt = false;
    private CompetitionQueue competitionQueue;
    private final AutoRunner autoRunner = new AutoRunner();
    private Map<UUID, Rarity> decidedRarities;
    private volatile boolean isUpdateAvailable;
    private DependencyManager dependencyManager;
    private ConfigurationManager configurationManager;
    private PluginDataManager pluginDataManager;
    private IntegrationManager integrationManager;
    private EventManager eventManager;
    private MetricsManager metricsManager;
    private static EvenMoreFish instance;
    private static TaskScheduler scheduler;
    private EMFAPI api;

    @NotNull
    public static EvenMoreFish getInstance() {
        return Objects.requireNonNull(instance, "Plugin not initialized yet!");
    }

    public static TaskScheduler getScheduler() {
        return scheduler;
    }

    public EvenMoreFish() {
        this.toggle = new Toggle(this);
    }

    public void onLoad() {
        if (!NBT.preloadApi()) {
            throw new RuntimeException("NBT-API wasn't initialized properly, disabling the plugin");
        }
        instance = this;
        this.loadCommands();
    }

    public abstract void loadCommands();

    public abstract void enableCommands();

    public abstract void registerCommands();

    public void onEnable() {
        this.enableCommands();
        scheduler = UniversalScheduler.getScheduler((Plugin)this);
        this.api = new EMFAPI();
        this.decidedRarities = new HashMap<UUID, Rarity>();
        this.configurationManager = new ConfigurationManager(this);
        this.configurationManager.loadConfigurations();
        this.dependencyManager = new DependencyManager(this);
        this.dependencyManager.checkDependencies();
        this.integrationManager = new IntegrationManager(this);
        this.integrationManager.loadAddons();
        if (!Economy.getInstance().isEnabled()) {
            this.getLogger().warning("EvenMoreFish won't be hooking into economy. If this wasn't by choice in config.yml, please install Economy handling plugins.");
            this.getLogger().warning("This message may be a false positive, if you can spot a \"successfully hooked into \" message, it can be ignored.");
        }
        this.pluginDataManager = new PluginDataManager(this);
        this.eventManager = new EventManager(this);
        this.eventManager.registerCoreListeners();
        this.eventManager.registerOptionalListeners();
        FishManager.getInstance().load();
        BaitManager.getInstance().load();
        RodManager.getInstance().load();
        this.competitionQueue = new CompetitionQueue();
        this.competitionQueue.load();
        new UpdateChecker(this).checkUpdate().thenAccept(available -> {
            this.isUpdateAvailable = available;
            if (available.booleanValue()) {
                this.getLogger().warning("A new update is available! Download it from https://modrinth.com/plugin/evenmorefish");
            }
        });
        this.metricsManager = new MetricsManager(this);
        this.metricsManager.setupMetrics();
        this.autoRunner.start();
        this.registerCommands();
        this.getLogger().info(() -> "EvenMoreFish by Oheers : Enabled");
    }

    public abstract void disableCommands();

    public void onDisable() {
        this.disableCommands();
        this.terminateGuis();
        Competition active = Competition.getCurrentlyActive();
        if (active != null) {
            active.end(false);
        }
        if (this.pluginDataManager != null) {
            this.pluginDataManager.shutdown();
        }
        this.competitionQueue.unload();
        RodManager.getInstance().unload();
        BaitManager.getInstance().unload();
        FishManager.getInstance().unload();
        this.getLogger().info(() -> "EvenMoreFish by Oheers : Disabled");
    }

    @Override
    public boolean isDebugSession() {
        return MainConfig.getInstance().debugSession();
    }

    private void terminateGuis() {
        this.getServer().getOnlinePlayers().forEach(player -> {
            InventoryGui inventoryGui = InventoryGui.getOpen((HumanEntity)player);
            if (inventoryGui != null) {
                inventoryGui.close();
            }
        });
    }

    @Override
    public void reload(@Nullable CommandSender sender) {
        this.terminateGuis();
        this.configurationManager.reloadConfigurations();
        FishManager.getInstance().reload();
        BaitManager.getInstance().reload();
        RodManager.getInstance().reload();
        HandlerList.unregisterAll((Listener)FishInteractEvent.getInstance());
        HandlerList.unregisterAll((Listener)McMMOTreasureEvent.getInstance());
        this.eventManager.registerOptionalListeners();
        this.competitionQueue.reload();
        if (sender != null) {
            ConfigMessage.RELOAD_SUCCESS.getMessage().send((Audience)sender);
        }
    }

    public Random getRandom() {
        return this.random;
    }

    public Toggle getToggle() {
        return this.toggle;
    }

    public boolean isRaritiesCompCheckExempt() {
        return this.raritiesCompCheckExempt;
    }

    public void setRaritiesCompCheckExempt(boolean exempt) {
        this.raritiesCompCheckExempt = exempt;
    }

    public CompetitionQueue getCompetitionQueue() {
        return this.competitionQueue;
    }

    public AutoRunner getAutoRunner() {
        return this.autoRunner;
    }

    public Map<UUID, Rarity> getDecidedRarities() {
        return this.decidedRarities;
    }

    public boolean isUpdateAvailable() {
        return this.isUpdateAvailable;
    }

    public EMFAPI getApi() {
        return this.api;
    }

    public List<Player> getVisibleOnlinePlayers() {
        return List.copyOf(Bukkit.getOnlinePlayers());
    }

    public DependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    public PluginDataManager getPluginDataManager() {
        return this.pluginDataManager;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public MetricsManager getMetricsManager() {
        return this.metricsManager;
    }
}

