/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.addons;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.addons.external.requirement.PermissionRequirementType;
import com.oheers.fish.addons.external.reward.AuraSkillsXPRewardType;
import com.oheers.fish.addons.external.reward.GPClaimBlocksRewardType;
import com.oheers.fish.addons.external.reward.McMMOXPRewardType;
import com.oheers.fish.addons.external.reward.MoneyRewardType;
import com.oheers.fish.addons.external.reward.PermissionRewardType;
import com.oheers.fish.addons.external.reward.PlayerPointsRewardType;
import com.oheers.fish.addons.internal.item.Head64ItemAddon;
import com.oheers.fish.addons.internal.requirement.BiomeRequirementType;
import com.oheers.fish.addons.internal.requirement.BiomeSetRequirementType;
import com.oheers.fish.addons.internal.requirement.DisabledRequirementType;
import com.oheers.fish.addons.internal.requirement.GroupRequirementType;
import com.oheers.fish.addons.internal.requirement.IRLTimeRequirementType;
import com.oheers.fish.addons.internal.requirement.InGameTimeRequirementType;
import com.oheers.fish.addons.internal.requirement.MoonPhaseRequirementType;
import com.oheers.fish.addons.internal.requirement.NearbyPlayersRequirementType;
import com.oheers.fish.addons.internal.requirement.RegionRequirementType;
import com.oheers.fish.addons.internal.requirement.WeatherRequirementType;
import com.oheers.fish.addons.internal.requirement.WorldRequirementType;
import com.oheers.fish.addons.internal.reward.CommandRewardType;
import com.oheers.fish.addons.internal.reward.EXPRewardType;
import com.oheers.fish.addons.internal.reward.EffectRewardType;
import com.oheers.fish.addons.internal.reward.HealthRewardType;
import com.oheers.fish.addons.internal.reward.HungerRewardType;
import com.oheers.fish.addons.internal.reward.ItemRewardType;
import com.oheers.fish.addons.internal.reward.MessageRewardType;
import com.oheers.fish.addons.internal.reward.SoundRewardType;
import com.oheers.fish.api.addons.AddonLoader;
import com.oheers.fish.api.addons.AddonMetadata;
import com.oheers.fish.api.plugin.EMFPlugin;
import com.oheers.fish.plugin.DependencyManager;
import java.util.List;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.plugin.RegisteredServiceProvider;

public class InternalAddonLoader
extends AddonLoader {
    public InternalAddonLoader(EMFPlugin plugin) {
        super(plugin, null);
    }

    @Override
    public AddonMetadata getAddonMetadata() {
        return new AddonMetadata("Internal Addons", "1.0.0", List.of("EvenMoreFish"), "Bundled internal addons", "https://github.com/EvenMoreFish/EvenMoreFish", List.of(""));
    }

    @Override
    public boolean canLoad() {
        return true;
    }

    @Override
    public void loadAddons() {
        this.loadItemAddons();
        this.loadRewardTypes();
        this.loadRequirementTypes();
    }

    private void loadItemAddons() {
        new Head64ItemAddon().register();
    }

    private void loadRewardTypes() {
        new CommandRewardType().register();
        new EffectRewardType().register();
        new HealthRewardType().register();
        new HungerRewardType().register();
        new ItemRewardType().register();
        new MessageRewardType().register();
        new EXPRewardType().register();
        new SoundRewardType().register();
        this.loadExternalRewardTypes();
    }

    private void loadRequirementTypes() {
        new BiomeRequirementType().register();
        new BiomeSetRequirementType().register();
        new DisabledRequirementType().register();
        new InGameTimeRequirementType().register();
        new IRLTimeRequirementType().register();
        new MoonPhaseRequirementType().register();
        new NearbyPlayersRequirementType().register();
        new PermissionRequirementType().register();
        new RegionRequirementType().register();
        new WeatherRequirementType().register();
        new WorldRequirementType().register();
        Permission permission = EvenMoreFish.getInstance().getDependencyManager().getPermission();
        if (permission != null) {
            new GroupRequirementType(permission).register();
        }
    }

    private void loadExternalRewardTypes() {
        RegisteredServiceProvider rsp;
        Permission permission;
        DependencyManager dependencyManager = EvenMoreFish.getInstance().getDependencyManager();
        if (dependencyManager.isUsingPlayerPoints()) {
            new PlayerPointsRewardType().register();
        }
        if (dependencyManager.isUsingGriefPrevention()) {
            new GPClaimBlocksRewardType().register();
        }
        if (dependencyManager.isUsingAuraSkills()) {
            new AuraSkillsXPRewardType().register();
        }
        if (dependencyManager.isUsingMcMMO()) {
            new McMMOXPRewardType().register();
        }
        if ((permission = EvenMoreFish.getInstance().getDependencyManager().getPermission()) != null && permission.isEnabled()) {
            new PermissionRewardType().register();
        }
        if (dependencyManager.isUsingVault() && (rsp = Bukkit.getServicesManager().getRegistration(Economy.class)) != null) {
            new MoneyRewardType().register();
        }
    }
}

