/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.addons.external.reward;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.api.economy.Economy;
import com.oheers.fish.api.economy.EconomyType;
import com.oheers.fish.api.reward.RewardType;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class MoneyRewardType
extends RewardType {
    @Override
    public void doReward(@NotNull Player player, @NotNull String key, @NotNull String value, Location hookLocation) {
        int amount;
        Economy economy = Economy.getInstance();
        try {
            amount = Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            EvenMoreFish.getInstance().getLogger().warning("Invalid number specified for RewardType " + this.getIdentifier() + ": " + value);
            return;
        }
        if (!economy.isEnabled()) {
            return;
        }
        Optional<EconomyType> vault = economy.getEconomyType("Vault");
        if (vault.isEmpty()) {
            return;
        }
        vault.get().deposit((OfflinePlayer)player, amount, false);
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return "MONEY";
    }

    @Override
    @NotNull
    public String getAuthor() {
        return "Oheers";
    }

    @NotNull
    public JavaPlugin getPlugin() {
        return EvenMoreFish.getInstance();
    }
}

