/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.addons.internal.requirement;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.FishUtils;
import com.oheers.fish.api.requirement.RequirementContext;
import com.oheers.fish.api.requirement.RequirementType;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class BiomeRequirementType
extends RequirementType {
    @Override
    public boolean checkRequirement(@NotNull RequirementContext context, @NotNull List<String> values) {
        World world = context.getWorld();
        Location location = context.getHookOrPlayerLocation();
        String configLocation = context.getConfigPath();
        if (configLocation == null) {
            configLocation = "N/A";
        }
        if (world == null) {
            EvenMoreFish.getInstance().getLogger().severe("Could not get world for " + configLocation + ", returning false by default. The player may not have been given a fish if you see this message multiple times.");
            return false;
        }
        if (location == null) {
            EvenMoreFish.getInstance().getLogger().severe("Could not get location for " + configLocation + ", returning false by default. The player may not have been given a fish if you see this message multiple times.");
            return false;
        }
        Biome hookBiome = location.getBlock().getBiome();
        for (String value : values) {
            Biome biome = FishUtils.getBiome(value);
            if (biome == null || !hookBiome.equals((Object)biome)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return "BIOME";
    }

    @Override
    @NotNull
    public String getAuthor() {
        return "Oheers";
    }

    @Override
    @NotNull
    public Plugin getPlugin() {
        return EvenMoreFish.getInstance();
    }
}

