/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.addons.internal.requirement;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.api.requirement.RequirementContext;
import com.oheers.fish.api.requirement.RequirementType;
import java.util.List;
import org.bukkit.WeatherType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class WeatherRequirementType
extends RequirementType {
    @Override
    public boolean checkRequirement(@NotNull RequirementContext context, @NotNull List<String> values) {
        if (context.getWorld() == null) {
            String configLocation = context.getConfigPath();
            if (configLocation == null) {
                configLocation = "N/A";
            }
            EvenMoreFish.getInstance().getLogger().severe("Could not get world for " + configLocation + ", returning false by default. The player may not have been given a fish if you see this message multiple times.");
            return false;
        }
        boolean isClear = context.getWorld().isClearWeather();
        for (String value : values) {
            WeatherType weatherType;
            try {
                weatherType = WeatherType.valueOf((String)value);
            }
            catch (IllegalArgumentException exception) {
                EvenMoreFish.getInstance().getLogger().severe(value + " is not a valid weather type.");
                return false;
            }
            if (!(isClear ? weatherType.equals((Object)WeatherType.CLEAR) : weatherType.equals((Object)WeatherType.DOWNFALL))) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return "WEATHER";
    }

    @Override
    @NotNull
    public String getAuthor() {
        return "Oheers";
    }

    @Override
    @NotNull
    public Plugin getPlugin() {
        return EvenMoreFish.getInstance();
    }
}

