/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.baits;

import com.oheers.fish.Checks;
import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.baits.BaitHandler;
import com.oheers.fish.baits.manager.BaitManager;
import com.oheers.fish.baits.manager.BaitNBTManager;
import com.oheers.fish.baits.model.ApplicationResult;
import com.oheers.fish.config.MainConfig;
import com.oheers.fish.exceptions.MaxBaitReachedException;
import com.oheers.fish.exceptions.MaxBaitsReachedException;
import com.oheers.fish.messages.ConfigMessage;
import com.oheers.fish.messages.abstracted.EMFMessage;
import com.oheers.fish.utils.nbt.NbtKeys;
import com.oheers.fish.utils.nbt.NbtUtils;
import com.oheers.fish.utils.nbt.NbtVersion;
import com.oheers.fish.utils.nbtapi.NBT;
import com.oheers.fish.utils.nbtapi.iface.ReadWriteNBT;
import net.kyori.adventure.audience.Audience;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public class BaitApplicationListener
implements Listener {
    @EventHandler
    public void onClickEvent(InventoryClickEvent event) {
        ApplicationResult result;
        ItemStack potentialFishingRod = event.getCurrentItem();
        ItemStack cursor = event.getCursor();
        if (MainConfig.getInstance().shouldProtectBaitedRods() && this.anvilCheck(event)) {
            return;
        }
        if (!BaitNBTManager.isBaitObject(cursor) || potentialFishingRod == null || !(event.getClickedInventory() instanceof PlayerInventory)) {
            return;
        }
        if (!potentialFishingRod.getType().equals((Object)Material.FISHING_ROD)) {
            return;
        }
        if (!Checks.canUseRod(potentialFishingRod)) {
            ConfigMessage.BAIT_INVALID_ROD.getMessage().send((Audience)event.getWhoClicked());
            return;
        }
        GameMode gameMode = event.getWhoClicked().getGameMode();
        if (!gameMode.equals((Object)GameMode.SURVIVAL) && !gameMode.equals((Object)GameMode.ADVENTURE)) {
            ConfigMessage.BAIT_WRONG_GAMEMODE.getMessage().send((Audience)event.getWhoClicked());
            return;
        }
        BaitHandler bait = BaitManager.getInstance().getBait(BaitNBTManager.getBaitName(event.getCursor()));
        if (bait == null) {
            return;
        }
        NbtVersion nbtVersion = NbtVersion.getVersion(potentialFishingRod);
        if (nbtVersion != NbtVersion.COMPAT) {
            this.convertToCompatNbtItem(nbtVersion, potentialFishingRod);
        }
        try {
            if (event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY) {
                result = BaitNBTManager.applyBaitedRodNBT(potentialFishingRod, bait, event.getCursor().getAmount());
                EvenMoreFish.getInstance().getMetricsManager().incrementBaitsApplied(event.getCursor().getAmount());
            } else {
                result = BaitNBTManager.applyBaitedRodNBT(potentialFishingRod, bait, 1);
                EvenMoreFish.getInstance().getMetricsManager().incrementBaitsApplied(1);
            }
        }
        catch (MaxBaitsReachedException exception) {
            ConfigMessage.BAITS_MAXED.getMessage().send((Audience)event.getWhoClicked());
            result = exception.getRecoveryResult();
        }
        catch (MaxBaitReachedException exception) {
            result = exception.getRecoveryResult();
            EMFMessage message = ConfigMessage.BAITS_MAXED_ON_ROD.getMessage();
            message.setBait(bait.format(bait.getId()));
            message.send((Audience)event.getWhoClicked());
        }
        if (result == null || result.getFishingRod() == null) {
            return;
        }
        event.setCancelled(true);
        event.setCurrentItem(result.getFishingRod());
        int cursorModifier = result.getCursorItemModifier();
        if (cursor.getAmount() - cursorModifier == 0) {
            event.getWhoClicked().setItemOnCursor(new ItemStack(Material.AIR));
        } else {
            cursor.setAmount(cursor.getAmount() + cursorModifier);
            event.getWhoClicked().setItemOnCursor(cursor);
        }
    }

    private void convertToCompatNbtItem(NbtVersion nbtVersion, ItemStack fishingRod) {
        String appliedBaitString = NbtUtils.getString(fishingRod, "emf-applied-bait");
        if (nbtVersion == NbtVersion.LEGACY) {
            String namespacedKey = NbtKeys.EMF_COMPOUND + ":emf-applied-bait";
            NBT.modify(fishingRod, nbt -> {
                ReadWriteNBT compound = nbt.getCompound("PublicBukkitValues");
                if (compound != null) {
                    compound.removeKey(namespacedKey);
                }
            });
            if (NBT.get(fishingRod, nbt -> nbt.hasTag(namespacedKey)).booleanValue()) {
                NBT.modify(fishingRod, nbt -> {
                    nbt.removeKey(namespacedKey);
                    ReadWriteNBT compound = nbt.getCompound("display");
                    if (compound != null) {
                        compound.getStringList("Lore").clear();
                    }
                });
            }
        }
        if (nbtVersion == NbtVersion.NBTAPI) {
            NBT.modify(fishingRod, nbt -> nbt.removeKey(NbtKeys.EMF_COMPOUND + ":emf-applied-bait"));
        }
        NBT.modify(fishingRod, nbt -> nbt.getOrCreateCompound(NbtKeys.EMF_COMPOUND).setString("emf-applied-bait", appliedBaitString));
    }

    private boolean anvilCheck(InventoryClickEvent event) {
        AnvilInventory inv;
        Inventory inventory;
        block5: {
            block4: {
                inventory = event.getClickedInventory();
                if (!(inventory instanceof AnvilInventory)) break block4;
                inv = (AnvilInventory)inventory;
                inventory = event.getWhoClicked();
                if (inventory instanceof Player) break block5;
            }
            return false;
        }
        Player player = (Player)inventory;
        if (event.getSlot() == 2 && BaitNBTManager.isBaitedRod(inv.getItem(1))) {
            event.setCancelled(true);
            player.closeInventory();
            ConfigMessage.BAIT_ROD_PROTECTION.getMessage().send((Audience)player);
            return true;
        }
        return false;
    }
}

