/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.commands.admin.subcommand;

import com.oheers.fish.commands.CommandUtils;
import com.oheers.fish.commands.admin.AdminCommand;
import com.oheers.fish.fishing.items.Fish;
import com.oheers.fish.fishing.items.FishManager;
import com.oheers.fish.fishing.items.Rarity;
import com.oheers.fish.messages.ConfigMessage;
import com.oheers.fish.messages.EMFSingleMessage;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentBuilder;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.command.CommandSender;

public class ListSubcommand {
    public void onDefault(CommandSender sender) {
        AdminCommand.sendHelpMessage(sender);
    }

    public void onFish(CommandSender sender, Rarity rarity) {
        if (rarity == null) {
            ConfigMessage.RARITY_INVALID.getMessage().send((Audience)sender);
            return;
        }
        TextComponent.Builder builder = Component.text();
        builder.append(rarity.getDisplayName().getComponentMessage());
        builder.append((Component)Component.space());
        for (Fish fish : rarity.getOriginalFishList()) {
            TextComponent.Builder fishBuilder = Component.text();
            EMFSingleMessage message = EMFSingleMessage.fromString("<gray>[</gray>{fish}<gray>]</gray>");
            message.setVariable("{fish}", fish.getDisplayName());
            fishBuilder.append(message.getComponentMessage());
            fishBuilder.hoverEvent((HoverEventSource)HoverEvent.hoverEvent((HoverEvent.Action)HoverEvent.Action.SHOW_TEXT, (Object)Component.text((String)"Click to receive fish")));
            fishBuilder.clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.RUN_COMMAND, (String)("/emf admin fish " + rarity.getId() + " " + fish.getName().replace(" ", "_"))));
            builder.append((ComponentBuilder)fishBuilder);
        }
        sender.sendMessage((Component)builder.build());
    }

    public void onRarities(CommandSender sender) {
        TextComponent.Builder builder = Component.text();
        for (Rarity rarity : FishManager.getInstance().getRarityMap().values()) {
            TextComponent.Builder rarityBuilder = Component.text();
            EMFSingleMessage message = EMFSingleMessage.fromString("<gray>[</gray>{rarity}<gray>]</gray>");
            message.setVariable("{rarity}", rarity.getDisplayName());
            rarityBuilder.append(message.getComponentMessage());
            rarityBuilder.hoverEvent((HoverEventSource)HoverEvent.hoverEvent((HoverEvent.Action)HoverEvent.Action.SHOW_TEXT, (Object)EMFSingleMessage.fromString("Click to view " + rarity.getId() + " fish.").getComponentMessage()));
            rarityBuilder.clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.RUN_COMMAND, (String)("/emf admin list fish " + rarity.getId())));
            builder.append((ComponentBuilder)rarityBuilder);
        }
        sender.sendMessage((Component)builder.build());
    }

    public void onRewardTypes(CommandSender sender) {
        CommandUtils.listRewardTypes((Audience)sender);
    }

    public void onRequirementTypes(CommandSender sender) {
        CommandUtils.listRequirementTypes((Audience)sender);
    }

    public void onItemAddons(CommandSender sender) {
        CommandUtils.listItemAddons((Audience)sender);
    }
}

