/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.commands.arguments;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.oheers.fish.baits.BaitHandler;
import com.oheers.fish.baits.manager.BaitManager;
import io.papermc.paper.command.brigadier.MessageComponentSerializer;
import io.papermc.paper.command.brigadier.argument.CustomArgumentType;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;

public class BaitArgument
implements CustomArgumentType.Converted<BaitHandler, String> {
    private static final DynamicCommandExceptionType NOT_BAIT = new DynamicCommandExceptionType(obj -> (Message)MessageComponentSerializer.message().serialize((Component)Component.text((String)(String.valueOf(obj) + " is not a valid bait!"))));

    public BaitHandler convert(String nativeType) throws CommandSyntaxException {
        BaitHandler bait = BaitManager.getInstance().getBait(nativeType);
        if (bait == null) {
            bait = BaitManager.getInstance().getBait(nativeType.replace("_", " "));
        }
        if (bait == null) {
            throw NOT_BAIT.create((Object)nativeType);
        }
        return bait;
    }

    @NotNull
    public ArgumentType<String> getNativeType() {
        return StringArgumentType.string();
    }

    @NotNull
    public <S> CompletableFuture<Suggestions> listSuggestions(@NotNull CommandContext<S> context, @NotNull SuggestionsBuilder builder) {
        BaitManager.getInstance().getItemMap().keySet().stream().map(s -> s.replace(" ", "_")).filter(name -> name.toLowerCase().startsWith(builder.getRemainingLowerCase())).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }
}

