/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.commands.arguments;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.oheers.fish.fishing.items.FishManager;
import com.oheers.fish.fishing.items.Rarity;
import io.papermc.paper.command.brigadier.MessageComponentSerializer;
import io.papermc.paper.command.brigadier.argument.CustomArgumentType;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;

public class RarityArgument
implements CustomArgumentType.Converted<Rarity, String> {
    private static final DynamicCommandExceptionType UNKNOWN_RARITY = new DynamicCommandExceptionType(obj -> (Message)MessageComponentSerializer.message().serialize((Component)Component.text((String)(String.valueOf(obj) + " is not a valid rarity!"))));

    public Rarity convert(String nativeType) throws CommandSyntaxException {
        Rarity rarity = FishManager.getInstance().getRarity(nativeType);
        if (rarity == null) {
            throw UNKNOWN_RARITY.create((Object)nativeType);
        }
        return rarity;
    }

    @NotNull
    public ArgumentType<String> getNativeType() {
        return StringArgumentType.string();
    }

    @NotNull
    public <S> CompletableFuture<Suggestions> listSuggestions(@NotNull CommandContext<S> context, @NotNull SuggestionsBuilder builder) {
        FishManager.getInstance().getRarityMap().keySet().stream().filter(name -> name.toLowerCase().startsWith(builder.getRemainingLowerCase())).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }
}

