/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.commands.main;

import com.oheers.fish.Checks;
import com.oheers.fish.commands.CommandUtils;
import com.oheers.fish.commands.HelpMessageBuilder;
import com.oheers.fish.commands.admin.AdminCommand;
import com.oheers.fish.commands.main.subcommand.JournalSubcommand;
import com.oheers.fish.commands.main.subcommand.ShopSubcommand;
import com.oheers.fish.commands.main.subcommand.ToggleSubcommand;
import com.oheers.fish.competition.Competition;
import com.oheers.fish.config.MainConfig;
import com.oheers.fish.gui.guis.ApplyBaitsGui;
import com.oheers.fish.gui.guis.MainMenuGui;
import com.oheers.fish.messages.ConfigMessage;
import com.oheers.fish.messages.PrefixType;
import com.oheers.fish.messages.abstracted.EMFMessage;
import com.oheers.fish.selling.SellHelper;
import net.kyori.adventure.audience.Audience;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;

public class MainCommand {
    private static final HelpMessageBuilder HELP_MESSAGE = HelpMessageBuilder.create().addUsage(MainConfig.getInstance().getAdminSubCommandName(), ConfigMessage.HELP_GENERAL_ADMIN::getMessage).addUsage(MainConfig.getInstance().getHelpSubCommandName(), ConfigMessage.HELP_GENERAL_HELP::getMessage).addUsage(MainConfig.getInstance().getGuiSubCommandName(), ConfigMessage.HELP_GENERAL_GUI::getMessage).addUsage(MainConfig.getInstance().getTopSubCommandName(), ConfigMessage.HELP_GENERAL_TOP::getMessage).addUsage(MainConfig.getInstance().getSellAllSubCommandName(), ConfigMessage.HELP_GENERAL_SELLALL::getMessage).addUsage(MainConfig.getInstance().getApplyBaitsSubCommandName(), ConfigMessage.HELP_GENERAL_APPLYBAITS::getMessage).addUsage(MainConfig.getInstance().getJournalSubCommandName(), ConfigMessage.HELP_GENERAL_JOURNAL::getMessage).addUsage(MainConfig.getInstance().getNextSubCommandName(), ConfigMessage.HELP_GENERAL_NEXT::getMessage).addUsage(MainConfig.getInstance().getToggleSubCommandName(), ConfigMessage.HELP_GENERAL_TOGGLE::getMessage);
    AdminCommand adminCommand = new AdminCommand();
    ShopSubcommand shopSubcommand = new ShopSubcommand();
    JournalSubcommand journalSubcommand = new JournalSubcommand();
    ToggleSubcommand toggleSubcommand = new ToggleSubcommand();

    public void onDefault(@NotNull CommandSender sender) {
        if (!sender.hasPermission("emf.gui") || MainConfig.getInstance().useOldBaseCommandBehavior()) {
            MainCommand.sendHelpMessage(sender);
            return;
        }
        if (!(sender instanceof Player)) {
            MainCommand.sendHelpMessage(sender);
            return;
        }
        Player player = (Player)sender;
        new MainMenuGui((HumanEntity)player).open();
    }

    public void onNext(CommandSender sender) {
        EMFMessage message = Competition.getNextCompetitionMessage();
        message.prependMessage(PrefixType.DEFAULT.getPrefix());
        message.send((Audience)sender);
    }

    public void onHelp(CommandSender sender) {
        MainCommand.sendHelpMessage(sender);
    }

    public void onGui(CommandSender sender, Player player) {
        new MainMenuGui((HumanEntity)player).open();
    }

    public void onTop(CommandSender sender) {
        Competition active = Competition.getCurrentlyActive();
        if (active == null) {
            ConfigMessage.NO_COMPETITION_RUNNING.getMessage().send((Audience)sender);
            return;
        }
        active.sendLeaderboard(sender);
    }

    public void onSellAll(CommandSender sender, Player player) {
        if (CommandUtils.isEconomyEnabled((CommandSender)player)) {
            new SellHelper((Inventory)player.getInventory(), player).sellFish();
        }
    }

    public void onApplyBaits(CommandSender sender, @NotNull Player player) {
        if (!Checks.canUseRod(player.getInventory().getItemInMainHand())) {
            ConfigMessage.BAIT_INVALID_ROD.getMessage().send((Audience)player);
            return;
        }
        new ApplyBaitsGui(player, null).open();
    }

    public static void sendHelpMessage(CommandSender sender) {
        HELP_MESSAGE.sendMessage(sender);
    }
}

