/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.database.execute;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.database.connection.ConnectionFactory;
import com.oheers.fish.database.execute.ExecuteBase;
import com.oheers.fish.libs.jooq.DSLContext;
import com.oheers.fish.libs.jooq.conf.Settings;
import java.sql.Connection;
import java.util.logging.Level;

public abstract class ExecuteQuery<T>
extends ExecuteBase {
    protected ExecuteQuery(ConnectionFactory connectionFactory, Settings settings) {
        super(connectionFactory, settings);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T prepareAndRunQuery() {
        try (Connection connection = this.getConnection();){
            DSLContext dslContext = this.getContext(connection);
            T t = this.onRunQuery(dslContext);
            return t;
        }
        catch (Exception e) {
            EvenMoreFish.getInstance().getLogger().log(Level.SEVERE, "Query execution failed", e);
            return this.empty();
        }
    }

    protected abstract T onRunQuery(DSLContext var1) throws Exception;

    protected abstract T empty();
}

