/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.economy;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.api.economy.EconomyType;
import com.oheers.fish.config.MainConfig;
import com.oheers.fish.messages.EMFSingleMessage;
import java.util.logging.Level;
import me.ryanhamshire.GriefPrevention.GriefPrevention;
import me.ryanhamshire.GriefPrevention.PlayerData;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GriefPreventionEconomyType
implements EconomyType {
    private GriefPrevention economy = null;

    public GriefPreventionEconomyType() {
        EvenMoreFish emf = EvenMoreFish.getInstance();
        emf.getLogger().log(Level.INFO, "Economy attempting to hook into GriefPrevention.");
        if (Bukkit.getPluginManager().isPluginEnabled("GriefPrevention")) {
            this.economy = GriefPrevention.instance;
            emf.getLogger().log(Level.INFO, "Economy hooked into GriefPrevention.");
        }
    }

    @Override
    public String getIdentifier() {
        return "GriefPrevention";
    }

    @Override
    public double getMultiplier() {
        return MainConfig.getInstance().getEconomyMultiplier(this);
    }

    @Override
    public boolean deposit(@NotNull OfflinePlayer player, double amount, boolean allowMultiplier) {
        if (!this.isAvailable()) {
            return false;
        }
        PlayerData data = this.economy.dataStore.getPlayerData(player.getUniqueId());
        data.setBonusClaimBlocks(Integer.valueOf(data.getBonusClaimBlocks() + (int)this.prepareValue(amount, allowMultiplier)));
        return true;
    }

    @Override
    public boolean withdraw(@NotNull OfflinePlayer player, double amount, boolean allowMultiplier) {
        if (!this.isAvailable()) {
            return false;
        }
        PlayerData data = this.economy.dataStore.getPlayerData(player.getUniqueId());
        int total = data.getBonusClaimBlocks();
        int finalTotal = total - (int)this.prepareValue(amount, allowMultiplier);
        if (finalTotal < 0) {
            return false;
        }
        data.setBonusClaimBlocks(Integer.valueOf(finalTotal));
        return true;
    }

    @Override
    public boolean has(@NotNull OfflinePlayer player, double amount) {
        if (!this.isAvailable()) {
            return false;
        }
        return this.get(player) >= amount;
    }

    @Override
    public double get(@NotNull OfflinePlayer player) {
        if (!this.isAvailable()) {
            return 0.0;
        }
        return this.economy.dataStore.getPlayerData(player.getUniqueId()).getBonusClaimBlocks();
    }

    @Override
    public double prepareValue(double value, boolean applyMultiplier) {
        if (applyMultiplier) {
            return Math.floor(value * this.getMultiplier());
        }
        return Math.floor(value);
    }

    @Override
    @Nullable
    public Component formatWorth(double totalWorth, boolean applyMultiplier) {
        if (!this.isAvailable()) {
            return null;
        }
        int worth = (int)this.prepareValue(totalWorth, applyMultiplier);
        String display = MainConfig.getInstance().getEconomyDisplay(this);
        if (display == null) {
            display = "{amount} Claim Block(s)";
        }
        EMFSingleMessage message = EMFSingleMessage.fromString(display);
        message.setVariable("{amount}", String.valueOf(worth));
        return message.getComponentMessage();
    }

    @Override
    public boolean isAvailable() {
        return MainConfig.getInstance().isEconomyEnabled(this) && this.economy != null;
    }
}

