/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Clause;
import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.Name;
import com.oheers.fish.libs.jooq.Record;
import com.oheers.fish.libs.jooq.SQLDialect;
import com.oheers.fish.libs.jooq.Select;
import com.oheers.fish.libs.jooq.Table;
import com.oheers.fish.libs.jooq.TableOptions;
import com.oheers.fish.libs.jooq.impl.AbstractTable;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.FieldsImpl;
import com.oheers.fish.libs.jooq.impl.Names;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.SelectQueryImpl;
import com.oheers.fish.libs.jooq.impl.TableAlias;
import com.oheers.fish.libs.jooq.impl.Tools;
import java.util.List;

final class AliasedSelect<R extends Record>
extends AbstractTable<R>
implements QOM.UTransient {
    private final Select<R> query;
    private final boolean subquery;
    private final boolean ignoreOrderBy;
    private final boolean forceLimit;
    private final Name[] aliases;

    AliasedSelect(Select<R> query, boolean subquery, boolean ignoreOrderBy, boolean forceLimit, Name ... aliases) {
        super(TableOptions.expression(), Names.NQ_SELECT);
        this.query = query;
        this.subquery = subquery;
        this.ignoreOrderBy = ignoreOrderBy;
        this.forceLimit = forceLimit;
        this.aliases = aliases;
    }

    final Select<R> query() {
        return this.query;
    }

    @Override
    public final Table<R> as(Name alias) {
        SelectQueryImpl q = Tools.selectQueryImpl(this.query);
        List<Field<?>> f = q.getSelect();
        if (q != null && (this.ignoreOrderBy && !q.getOrderBy().isEmpty() || Tools.hasEmbeddedFields(f) || Tools.isEmpty(this.aliases))) {
            if (Tools.isEmpty(this.aliases)) {
                return this.query.asTable(alias, Tools.fieldNames(Tools.collect(Tools.flattenCollection(f)).size()));
            }
            return this.query.asTable(alias, this.aliases);
        }
        return new TableAlias(this, alias, true);
    }

    @Override
    public final Table<R> as(Name alias, Name ... fieldAliases) {
        return new TableAlias(this, alias, fieldAliases, true);
    }

    @Override
    final FieldsImpl<R> fields0() {
        return new FieldsImpl(this.query.asTable(Names.N_T, this.aliases).fields());
    }

    @Override
    public final Class<? extends R> getRecordType() {
        return this.query.getRecordType();
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.forceLimit) {
            ctx.data(Tools.BooleanDataKey.DATA_FORCE_LIMIT_WITH_ORDER_BY, true, c -> this.accept0((Context<?>)c));
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        SelectQueryImpl q = Tools.selectQueryImpl(this.query);
        if (ctx.family() == SQLDialect.DERBY && q != null && q.hasUnions()) {
            Tools.visitSubquery(ctx, DSL.selectFrom(this.query.asTable(Names.N_T, this.aliases)), 1, false);
        } else {
            ctx.data(Tools.SimpleDataKey.DATA_SELECT_ALIASES, this.aliases, this.subquery ? c -> Tools.visitSubquery(c, this.query, 1, false) : c -> c.visit(this.query));
        }
    }

    static final boolean avoidAliasPushdown(Context<?> ctx, Select<?> query) {
        SelectQueryImpl q = Tools.selectQueryImpl(query);
        return q != null && (ctx.family() == SQLDialect.DERBY && q.hasUnions() || !q.getOrderBy().isEmpty() || Tools.hasEmbeddedFields(q.getSelect()));
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }
}

