/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.AlterViewFinalStep;
import com.oheers.fish.libs.jooq.AlterViewStep;
import com.oheers.fish.libs.jooq.Clause;
import com.oheers.fish.libs.jooq.Comment;
import com.oheers.fish.libs.jooq.Configuration;
import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.Function7;
import com.oheers.fish.libs.jooq.Name;
import com.oheers.fish.libs.jooq.SQLDialect;
import com.oheers.fish.libs.jooq.Select;
import com.oheers.fish.libs.jooq.Table;
import com.oheers.fish.libs.jooq.impl.AbstractDDLQuery;
import com.oheers.fish.libs.jooq.impl.DDLStatementType;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.Keywords;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.QueryPartCollectionView;
import com.oheers.fish.libs.jooq.impl.QueryPartList;
import com.oheers.fish.libs.jooq.impl.QueryPartListView;
import com.oheers.fish.libs.jooq.impl.Tools;
import java.util.Collection;
import java.util.Set;

final class AlterViewImpl
extends AbstractDDLQuery
implements QOM.AlterView,
AlterViewStep,
AlterViewFinalStep {
    final Table<?> view;
    final QueryPartListView<? extends Field<?>> fields;
    final boolean materialized;
    final boolean ifExists;
    Comment comment;
    Table<?> renameTo;
    Select<?> as;
    private static final Clause[] CLAUSES = new Clause[]{Clause.ALTER_VIEW};
    private static final Set<SQLDialect> NO_SUPPORT_RENAME_IF_EXISTS = SQLDialect.supportedUntil(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD);
    private static final Set<SQLDialect> NO_SUPPORT_IF_EXISTS = SQLDialect.supportedUntil(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD);
    private static final Set<SQLDialect> SUPPORT_ALTER_TABLE_RENAME = SQLDialect.supportedBy(SQLDialect.HSQLDB, SQLDialect.YUGABYTEDB);

    AlterViewImpl(Configuration configuration, Table<?> view, Collection<? extends Field<?>> fields, boolean materialized, boolean ifExists) {
        this(configuration, view, fields, materialized, ifExists, null, null, null);
    }

    AlterViewImpl(Configuration configuration, Table<?> view, boolean materialized, boolean ifExists) {
        this(configuration, view, null, materialized, ifExists);
    }

    AlterViewImpl(Configuration configuration, Table<?> view, Collection<? extends Field<?>> fields, boolean materialized, boolean ifExists, Comment comment, Table<?> renameTo, Select<?> as) {
        super(configuration);
        this.view = view;
        this.fields = new QueryPartList((Iterable<Field<?>>)fields);
        this.materialized = materialized;
        this.ifExists = ifExists;
        this.comment = comment;
        this.renameTo = renameTo;
        this.as = as;
    }

    @Override
    public final AlterViewImpl comment(String comment) {
        return this.comment(DSL.comment(comment));
    }

    @Override
    public final AlterViewImpl comment(Comment comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public final AlterViewImpl renameTo(String renameTo) {
        return this.renameTo((Table)DSL.table(DSL.name(renameTo)));
    }

    @Override
    public final AlterViewImpl renameTo(Name renameTo) {
        return this.renameTo((Table)DSL.table(renameTo));
    }

    @Override
    public final AlterViewImpl renameTo(Table<?> renameTo) {
        this.renameTo = renameTo;
        return this;
    }

    @Override
    public final AlterViewImpl as(Select<?> as) {
        this.as = as;
        return this;
    }

    private final boolean supportsIfExists(Context<?> ctx) {
        if (this.renameTo != null) {
            return !NO_SUPPORT_RENAME_IF_EXISTS.contains((Object)ctx.dialect());
        }
        return !NO_SUPPORT_IF_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifExists && !this.supportsIfExists(ctx)) {
            Tools.tryCatch(ctx, DDLStatementType.ALTER_VIEW, c -> this.accept0((Context<?>)c));
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        if (this.as != null) {
            switch (ctx.family()) {
                case CUBRID: 
                case DERBY: 
                case FIREBIRD: 
                case H2: 
                case HSQLDB: 
                case IGNITE: 
                case MARIADB: 
                case MYSQL: 
                case POSTGRES: 
                case SQLITE: 
                case YUGABYTEDB: {
                    if (this.materialized) {
                        ctx.visit(DSL.begin(DSL.dropMaterializedView(this.view), DSL.createMaterializedView(this.view, this.fields.toArray((E[])Tools.EMPTY_FIELD)).as(this.as)));
                        break;
                    }
                    ctx.visit(DSL.begin(DSL.dropView(this.view), DSL.createView(this.view, this.fields.toArray((E[])Tools.EMPTY_FIELD)).as(this.as)));
                    break;
                }
                default: {
                    ctx.visit(Keywords.K_ALTER).sql(' ');
                    if (this.materialized) {
                        ctx.visit(Keywords.K_MATERIALIZED).sql(' ');
                    }
                    ctx.visit(Keywords.K_VIEW).sql(' ').visit(this.view);
                    if (!this.fields.isEmpty()) {
                        ctx.sql(" (").visit(QueryPartCollectionView.wrap(this.fields).qualify(false)).sql(')');
                    }
                    ctx.formatSeparator().visit(Keywords.K_AS).formatSeparator().visit(this.as);
                }
            }
            return;
        }
        if (this.comment != null) {
            ctx.visit((this.materialized ? DSL.commentOnMaterializedView(this.view) : DSL.commentOnView(this.view)).is(this.comment));
            return;
        }
        this.accept1(ctx);
    }

    private final void accept1(Context<?> ctx) {
        ctx.start(Clause.ALTER_VIEW_VIEW).visit(Keywords.K_ALTER).sql(' ');
        if (SUPPORT_ALTER_TABLE_RENAME.contains((Object)ctx.dialect())) {
            ctx.visit(Keywords.K_TABLE).sql(' ');
        } else if (this.materialized) {
            ctx.visit(Keywords.K_MATERIALIZED).sql(' ').visit(Keywords.K_VIEW).sql(' ');
        } else {
            ctx.visit(Keywords.K_VIEW).sql(' ');
        }
        if (this.ifExists && this.supportsIfExists(ctx)) {
            ctx.sql(' ').visit(Keywords.K_IF_EXISTS);
        }
        ctx.sql(' ').visit(this.view).sql(' ').end(Clause.ALTER_VIEW_VIEW);
        if (this.renameTo != null) {
            ctx.start(Clause.ALTER_VIEW_RENAME).visit(Keywords.K_RENAME_TO).sql(' ').qualify(false, c -> c.visit(this.renameTo)).end(Clause.ALTER_VIEW_RENAME);
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    @Override
    public final Table<?> $view() {
        return this.view;
    }

    @Override
    public final QOM.UnmodifiableList<? extends Field<?>> $fields() {
        return QOM.unmodifiable(this.fields);
    }

    @Override
    public final boolean $materialized() {
        return this.materialized;
    }

    @Override
    public final boolean $ifExists() {
        return this.ifExists;
    }

    @Override
    public final Comment $comment() {
        return this.comment;
    }

    @Override
    public final Table<?> $renameTo() {
        return this.renameTo;
    }

    @Override
    public final Select<?> $as() {
        return this.as;
    }

    @Override
    public final QOM.AlterView $view(Table<?> newValue) {
        return this.$constructor().apply(newValue, this.$fields(), this.$materialized(), this.$ifExists(), this.$comment(), this.$renameTo(), this.$as());
    }

    @Override
    public final QOM.AlterView $fields(Collection<? extends Field<?>> newValue) {
        return this.$constructor().apply(this.$view(), newValue, this.$materialized(), this.$ifExists(), this.$comment(), this.$renameTo(), this.$as());
    }

    @Override
    public final QOM.AlterView $materialized(boolean newValue) {
        return this.$constructor().apply(this.$view(), this.$fields(), newValue, this.$ifExists(), this.$comment(), this.$renameTo(), this.$as());
    }

    @Override
    public final QOM.AlterView $ifExists(boolean newValue) {
        return this.$constructor().apply(this.$view(), this.$fields(), this.$materialized(), newValue, this.$comment(), this.$renameTo(), this.$as());
    }

    @Override
    public final QOM.AlterView $comment(Comment newValue) {
        return this.$constructor().apply(this.$view(), this.$fields(), this.$materialized(), this.$ifExists(), newValue, this.$renameTo(), this.$as());
    }

    @Override
    public final QOM.AlterView $renameTo(Table<?> newValue) {
        return this.$constructor().apply(this.$view(), this.$fields(), this.$materialized(), this.$ifExists(), this.$comment(), newValue, this.$as());
    }

    @Override
    public final QOM.AlterView $as(Select<?> newValue) {
        return this.$constructor().apply(this.$view(), this.$fields(), this.$materialized(), this.$ifExists(), this.$comment(), this.$renameTo(), newValue);
    }

    public final Function7<? super Table<?>, ? super Collection<? extends Field<?>>, ? super Boolean, ? super Boolean, ? super Comment, ? super Table<?>, ? super Select<?>, ? extends QOM.AlterView> $constructor() {
        return (a1, a2, a3, a4, a5, a6, a7) -> new AlterViewImpl(this.configuration(), (Table<?>)a1, (Collection<? extends Field<?>>)a2, (boolean)a3, (boolean)a4, (Comment)a5, (Table<?>)a6, (Select<?>)a7);
    }
}

