/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.CloseableDSLContext;
import com.oheers.fish.libs.jooq.ConnectionProvider;
import com.oheers.fish.libs.jooq.SQLDialect;
import com.oheers.fish.libs.jooq.conf.Settings;
import com.oheers.fish.libs.jooq.impl.DefaultCloseableConnectionProvider;
import com.oheers.fish.libs.jooq.impl.DefaultConnectionFactory;
import com.oheers.fish.libs.jooq.impl.DefaultDSLContext;
import com.oheers.fish.libs.jooq.impl.R2DBC;
import com.oheers.fish.libs.jooq.tools.jdbc.JDBCUtils;
import io.r2dbc.spi.ConnectionFactory;

public class DefaultCloseableDSLContext
extends DefaultDSLContext
implements CloseableDSLContext {
    public DefaultCloseableDSLContext(ConnectionProvider connectionProvider, SQLDialect dialect, Settings settings) {
        super(connectionProvider, dialect, settings);
    }

    public DefaultCloseableDSLContext(ConnectionProvider connectionProvider, SQLDialect dialect) {
        super(connectionProvider, dialect);
    }

    public DefaultCloseableDSLContext(ConnectionFactory connectionFactory, SQLDialect dialect, Settings settings) {
        super(connectionFactory, dialect, settings);
    }

    public DefaultCloseableDSLContext(ConnectionFactory connectionFactory, SQLDialect dialect) {
        super(connectionFactory, dialect);
    }

    @Override
    public void close() {
        ConnectionProvider cp = this.configuration().connectionProvider();
        ConnectionFactory cf = this.configuration().connectionFactory();
        if (cp instanceof DefaultCloseableConnectionProvider) {
            DefaultCloseableConnectionProvider dcp = (DefaultCloseableConnectionProvider)cp;
            JDBCUtils.safeClose(dcp.connection);
            dcp.connection = null;
        }
        if (cf instanceof DefaultConnectionFactory) {
            DefaultConnectionFactory dcf = (DefaultConnectionFactory)cf;
            if (dcf.finalize) {
                R2DBC.blockWrappingExceptions(dcf.connection.close());
                dcf.connection = null;
            }
        }
    }
}

