/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.DataType;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.Function1;
import com.oheers.fish.libs.jooq.SQLDialect;
import com.oheers.fish.libs.jooq.impl.AbstractField;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.DefaultDataType;
import com.oheers.fish.libs.jooq.impl.Names;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.SQLDataType;
import com.oheers.fish.libs.jooq.impl.Tools;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Set;

final class Digits
extends AbstractField<String>
implements QOM.Digits {
    final Field<? extends Number> value;
    private static final Set<SQLDialect> NO_SUPPORT_DIGITS = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.DUCKDB, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES, SQLDialect.SQLITE, SQLDialect.TRINO, SQLDialect.YUGABYTEDB);

    Digits(Field<? extends Number> value) {
        super(Names.N_DIGITS, Tools.allNotNull(SQLDataType.VARCHAR, value));
        this.value = Tools.nullSafeNotNull(value, SQLDataType.INTEGER);
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (NO_SUPPORT_DIGITS.contains((Object)ctx.dialect())) {
            DataType t = this.value.getDataType();
            if (t.getType() == Byte.class) {
                ctx.visit(DSL.lpad(DSL.abs(this.value).cast(SQLDataType.VARCHAR(DefaultDataType.BYTE_PRECISION)), DSL.inline(DefaultDataType.BYTE_PRECISION), DSL.inline("0")));
            } else if (t.getType() == Short.class) {
                ctx.visit(DSL.lpad(DSL.abs(this.value).cast(SQLDataType.VARCHAR(DefaultDataType.SHORT_PRECISION)), DSL.inline(DefaultDataType.SHORT_PRECISION), DSL.inline("0")));
            } else if (t.getType() == Integer.class) {
                ctx.visit(DSL.lpad(DSL.abs(this.value).cast(SQLDataType.VARCHAR(DefaultDataType.INTEGER_PRECISION)), DSL.inline(DefaultDataType.INTEGER_PRECISION), DSL.inline("0")));
            } else if (t.getType() == Long.class) {
                ctx.visit(DSL.lpad(DSL.abs(this.value).cast(SQLDataType.VARCHAR(DefaultDataType.LONG_PRECISION)), DSL.inline(DefaultDataType.LONG_PRECISION), DSL.inline("0")));
            } else if (t.scaleDefined()) {
                ctx.visit(DSL.lpad(DSL.abs(this.value.mul(DSL.inline(BigDecimal.TEN.pow(t.scale())))).cast(t.scale(0)).cast(SQLDataType.VARCHAR(t.precision())), DSL.inline(t.precision()), DSL.inline("0")));
            } else {
                ctx.visit(DSL.lpad(DSL.abs(this.value).cast(SQLDataType.VARCHAR(t.precision())), DSL.inline(t.precision()), DSL.inline("0")));
            }
        } else {
            ctx.visit(Names.N_DIGITS).sql('(').visit(this.value).sql(')');
        }
    }

    @Override
    public final Field<? extends Number> $arg1() {
        return this.value;
    }

    @Override
    public final QOM.Digits $arg1(Field<? extends Number> newValue) {
        return this.$constructor().apply((Field<? extends Number>)newValue);
    }

    @Override
    public final Function1<? super Field<? extends Number>, ? extends QOM.Digits> $constructor() {
        return a1 -> new Digits((Field<? extends Number>)a1);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.Digits) {
            QOM.Digits o = (QOM.Digits)that;
            return Objects.equals(this.$value(), o.$value());
        }
        return super.equals(that);
    }
}

