/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Clause;
import com.oheers.fish.libs.jooq.Configuration;
import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.DropIndexCascadeStep;
import com.oheers.fish.libs.jooq.DropIndexFinalStep;
import com.oheers.fish.libs.jooq.DropIndexOnStep;
import com.oheers.fish.libs.jooq.Function4;
import com.oheers.fish.libs.jooq.Index;
import com.oheers.fish.libs.jooq.Name;
import com.oheers.fish.libs.jooq.SQLDialect;
import com.oheers.fish.libs.jooq.Table;
import com.oheers.fish.libs.jooq.impl.AbstractDDLQuery;
import com.oheers.fish.libs.jooq.impl.DDLStatementType;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.Keywords;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.Tools;
import java.util.Set;

final class DropIndexImpl
extends AbstractDDLQuery
implements QOM.DropIndex,
DropIndexOnStep,
DropIndexCascadeStep,
DropIndexFinalStep {
    final Index index;
    final boolean ifExists;
    Table<?> on;
    QOM.Cascade cascade;
    private static final Clause[] CLAUSES = new Clause[]{Clause.DROP_INDEX};
    private static final Set<SQLDialect> NO_SUPPORT_IF_EXISTS = SQLDialect.supportedUntil(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.MYSQL);
    private static final Set<SQLDialect> REQUIRES_ON = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);

    DropIndexImpl(Configuration configuration, Index index, boolean ifExists) {
        this(configuration, index, ifExists, null, null);
    }

    DropIndexImpl(Configuration configuration, Index index, boolean ifExists, Table<?> on, QOM.Cascade cascade) {
        super(configuration);
        this.index = index;
        this.ifExists = ifExists;
        this.on = on;
        this.cascade = cascade;
    }

    @Override
    public final DropIndexImpl on(String on) {
        return this.on((Table)DSL.table(DSL.name(on)));
    }

    @Override
    public final DropIndexImpl on(Name on) {
        return this.on((Table)DSL.table(on));
    }

    @Override
    public final DropIndexImpl on(Table<?> on) {
        this.on = on;
        return this;
    }

    @Override
    public final DropIndexImpl cascade() {
        this.cascade = QOM.Cascade.CASCADE;
        return this;
    }

    @Override
    public final DropIndexImpl restrict() {
        this.cascade = QOM.Cascade.RESTRICT;
        return this;
    }

    private final boolean supportsIfExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifExists && !this.supportsIfExists(ctx)) {
            Tools.tryCatch(ctx, DDLStatementType.DROP_INDEX, c -> this.accept0((Context<?>)c));
        } else {
            this.accept0(ctx);
        }
    }

    private void accept0(Context<?> ctx) {
        ctx.visit(Keywords.K_DROP).sql(' ').visit(Keywords.K_INDEX).sql(' ');
        if (this.ifExists && this.supportsIfExists(ctx)) {
            ctx.visit(Keywords.K_IF_EXISTS).sql(' ');
        }
        ctx.visit(this.index);
        if (REQUIRES_ON.contains((Object)ctx.dialect())) {
            if (this.on != null) {
                ctx.sql(' ').visit(Keywords.K_ON).sql(' ').visit(this.on);
            } else if (this.index.getTable() != null) {
                ctx.sql(' ').visit(Keywords.K_ON).sql(' ').visit(this.index.getTable());
            }
        }
        DropIndexImpl.acceptCascade(ctx, this.cascade);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    @Override
    public final Index $index() {
        return this.index;
    }

    @Override
    public final boolean $ifExists() {
        return this.ifExists;
    }

    @Override
    public final Table<?> $on() {
        return this.on;
    }

    @Override
    public final QOM.Cascade $cascade() {
        return this.cascade;
    }

    @Override
    public final QOM.DropIndex $index(Index newValue) {
        return this.$constructor().apply(newValue, this.$ifExists(), this.$on(), this.$cascade());
    }

    @Override
    public final QOM.DropIndex $ifExists(boolean newValue) {
        return this.$constructor().apply(this.$index(), newValue, this.$on(), this.$cascade());
    }

    @Override
    public final QOM.DropIndex $on(Table<?> newValue) {
        return this.$constructor().apply(this.$index(), this.$ifExists(), newValue, this.$cascade());
    }

    @Override
    public final QOM.DropIndex $cascade(QOM.Cascade newValue) {
        return this.$constructor().apply(this.$index(), this.$ifExists(), this.$on(), newValue);
    }

    public final Function4<? super Index, ? super Boolean, ? super Table<?>, ? super QOM.Cascade, ? extends QOM.DropIndex> $constructor() {
        return (a1, a2, a3, a4) -> new DropIndexImpl(this.configuration(), (Index)a1, (boolean)a2, (Table<?>)a3, (QOM.Cascade)((Object)a4));
    }
}

