/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.Function2;
import com.oheers.fish.libs.jooq.impl.AbstractCondition;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.Tools;
import java.util.Objects;

final class EndsWithIgnoreCase<T>
extends AbstractCondition
implements QOM.EndsWithIgnoreCase<T> {
    final Field<T> string;
    final Field<T> suffix;

    EndsWithIgnoreCase(Field<T> string, Field<T> suffix) {
        this.string = Tools.nullableIf(false, Tools.nullSafe(string, suffix.getDataType()));
        this.suffix = Tools.nullableIf(false, Tools.nullSafe(suffix, string.getDataType()));
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case DUCKDB: {
                ctx.visit(this.string.lower().endsWith(this.suffix.lower()));
                break;
            }
            default: {
                ctx.visit(this.string.likeIgnoreCase(DSL.concat(DSL.inline("%"), Tools.escapeForLike(this.suffix, ctx.configuration())), '!'));
            }
        }
    }

    @Override
    public final Field<T> $arg1() {
        return this.string;
    }

    @Override
    public final Field<T> $arg2() {
        return this.suffix;
    }

    @Override
    public final QOM.EndsWithIgnoreCase<T> $arg1(Field<T> newValue) {
        return this.$constructor().apply(newValue, (Field<T>)this.$arg2());
    }

    @Override
    public final QOM.EndsWithIgnoreCase<T> $arg2(Field<T> newValue) {
        return this.$constructor().apply((Field<T>)this.$arg1(), newValue);
    }

    @Override
    public final Function2<? super Field<T>, ? super Field<T>, ? extends QOM.EndsWithIgnoreCase<T>> $constructor() {
        return (a1, a2) -> new EndsWithIgnoreCase(a1, a2);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.EndsWithIgnoreCase) {
            QOM.EndsWithIgnoreCase o = (QOM.EndsWithIgnoreCase)that;
            return Objects.equals(this.$string(), o.$string()) && Objects.equals(this.$suffix(), o.$suffix());
        }
        return super.equals(that);
    }
}

