/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.messages;

import com.oheers.fish.libs.messagelib.message.ComponentListMessage;
import com.oheers.fish.libs.messagelib.message.ComponentMessage;
import com.oheers.fish.libs.messagelib.message.ComponentSingleMessage;
import com.oheers.fish.messages.abstracted.EMFMessage;
import java.util.List;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EMFSingleMessage
extends EMFMessage {
    private ComponentSingleMessage underlying;

    protected EMFSingleMessage(@NotNull ComponentSingleMessage message) {
        this.underlying = message;
    }

    @Override
    public EMFSingleMessage createCopy() {
        EMFSingleMessage newMessage = new EMFSingleMessage(this.underlying.createCopy());
        newMessage.perPlayer = this.perPlayer;
        return newMessage;
    }

    @Override
    @NotNull
    public ComponentSingleMessage getUnderlying() {
        return this.underlying;
    }

    @Override
    public void setUnderlying(@NotNull ComponentMessage message) {
        if (message instanceof ComponentListMessage) {
            ComponentListMessage listMessage = (ComponentListMessage)message;
            this.underlying = listMessage.toSingleMessage();
        } else if (message instanceof ComponentSingleMessage) {
            ComponentSingleMessage singleMessage;
            this.underlying = singleMessage = (ComponentSingleMessage)message;
        } else {
            return;
        }
    }

    public static EMFSingleMessage empty() {
        return new EMFSingleMessage(ComponentMessage.componentMessage((Component)Component.empty()));
    }

    public static EMFSingleMessage ofUnderlying(@NotNull ComponentSingleMessage underlying) {
        return new EMFSingleMessage(underlying);
    }

    public static EMFSingleMessage of(@NotNull Component component) {
        return new EMFSingleMessage(ComponentMessage.componentMessage(component));
    }

    public static EMFSingleMessage ofList(@NotNull List<Component> components) {
        return new EMFSingleMessage(ComponentMessage.componentMessage(components).toSingleMessage());
    }

    public static EMFSingleMessage fromString(@NotNull String string) {
        return new EMFSingleMessage(ComponentMessage.componentMessage(string));
    }

    public static EMFSingleMessage fromStringList(@NotNull List<String> strings) {
        return new EMFSingleMessage(ComponentMessage.componentMessage(strings).toSingleMessage());
    }

    @NotNull
    public Component getRawMessage() {
        return this.underlying.get();
    }

    @Override
    @NotNull
    public Component getComponentMessage(@Nullable OfflinePlayer player) {
        OfflinePlayer relevant = this.relevantPlayer == null ? player : this.relevantPlayer;
        return this.underlying.parsePlaceholderAPI(relevant).replace("{player}", Optional.ofNullable(relevant).map(OfflinePlayer::getName).orElse("null")).get();
    }

    @Override
    @NotNull
    public List<Component> getComponentListMessage(@Nullable OfflinePlayer player) {
        return List.of(this.getComponentMessage(player));
    }

    @Override
    @NotNull
    public String getLegacyMessage() {
        return this.underlying.getAsLegacy();
    }

    @Override
    @NotNull
    public List<String> getLegacyListMessage() {
        return List.of(this.underlying.getAsLegacy());
    }

    @Override
    @NotNull
    public String getPlainTextMessage() {
        return this.underlying.getAsPlainText();
    }

    @Override
    @NotNull
    public List<String> getPlainTextListMessage() {
        return List.of(this.underlying.getAsPlainText());
    }

    @Override
    public void formatPlaceholderAPI() {
        this.underlying = this.underlying.parsePlaceholderAPI(this.relevantPlayer);
    }

    public void setMessage(@NotNull String message) {
        this.underlying = ComponentMessage.componentMessage(message).messageType(this.underlying.messageType());
    }

    public void setMessage(@NotNull Component message) {
        this.underlying = ComponentMessage.componentMessage(message).messageType(this.underlying.messageType());
    }

    public void setMessage(@NotNull EMFSingleMessage message) {
        this.underlying = message.underlying;
    }

    public void trim() {
        Component newComponent = MiniMessage.miniMessage().deserialize((Object)((String)MiniMessage.miniMessage().serialize(this.underlying.get())).stripTrailing());
        this.underlying = ComponentMessage.componentMessage(newComponent, this.underlying.messageType());
    }

    @Override
    public boolean containsString(@NotNull String string) {
        return this.underlying.containsString(string);
    }
}

