/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.utils;

import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemUtils {
    @NotNull
    public static Material getMaterial(@Nullable String materialName, @NotNull Material defaultMaterial) {
        Material material = ItemUtils.getMaterial(materialName);
        if (material == null) {
            return defaultMaterial;
        }
        return material;
    }

    @Nullable
    public static Material getMaterial(@Nullable String materialName) {
        if (materialName == null) {
            return null;
        }
        try {
            return Material.valueOf((String)materialName.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static boolean isValidMaterial(@Nullable String materialName) {
        if (materialName == null || materialName.isEmpty()) {
            return false;
        }
        try {
            Material.valueOf((String)materialName.toUpperCase());
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static void glowify(@NotNull ItemStack item) {
        item.addUnsafeEnchantment(Enchantment.DURABILITY, 1);
        item.editMeta(meta -> meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS}));
    }

    public static ItemStack changeMaterial(@NotNull ItemStack item, @NotNull Material material) {
        ItemStack newItem = new ItemStack(material);
        newItem.setItemMeta(item.getItemMeta());
        return newItem;
    }
}

