/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.addons.internal.requirement;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.api.requirement.RequirementContext;
import com.oheers.fish.api.requirement.RequirementType;
import java.util.List;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class GroupRequirementType
extends RequirementType {
    @NotNull
    private final Permission permission;

    public GroupRequirementType(@NotNull Permission permission) {
        this.permission = permission;
    }

    @Override
    public boolean checkRequirement(@NotNull RequirementContext context, @NotNull List<String> values) {
        Player player = context.getPlayer();
        if (player == null) {
            return false;
        }
        for (String value : values) {
            if (!this.permission.playerInGroup(player, value)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return "GROUP";
    }

    @Override
    @NotNull
    public String getAuthor() {
        return "FireML";
    }

    @Override
    @NotNull
    public Plugin getPlugin() {
        return EvenMoreFish.getInstance();
    }
}

