/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.api.addons;

import com.oheers.fish.api.addons.AddonMetadata;
import com.oheers.fish.api.plugin.EMFPlugin;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;

public abstract class AddonLoader {
    private final File addonFile;
    private final EMFPlugin plugin;
    private AddonMetadata cachedMetadata;

    protected AddonLoader(EMFPlugin plugin, File addonFile) {
        this.plugin = Objects.requireNonNull(plugin, "Plugin instance cannot be null");
        this.addonFile = addonFile;
    }

    public AddonMetadata getAddonMetadata() {
        if (this.cachedMetadata == null) {
            if (this.addonFile != null) {
                this.cachedMetadata = this.loadMetadataFromProperties(this.addonFile);
            }
            if (this.cachedMetadata == null) {
                this.cachedMetadata = this.loadAddonMetadata();
            }
            if (this.cachedMetadata == null) {
                throw new IllegalStateException("Could not load addon metadata - neither properties file exists nor metadata was provided");
            }
        }
        return this.cachedMetadata;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AddonMetadata loadMetadataFromProperties(File addonFile) {
        try (JarFile jar = new JarFile(addonFile);){
            List<String> dependencies;
            Manifest manifest = jar.getManifest();
            if (manifest == null) {
                this.plugin.getLogger().warning("No manifest found in addon: " + addonFile.getName());
                AddonMetadata addonMetadata = null;
                return addonMetadata;
            }
            Attributes attributes = manifest.getMainAttributes();
            String name = attributes.getValue("name");
            String version = attributes.getValue("version");
            String authorsStr = attributes.getValue("authors");
            String website = attributes.getValue("website");
            String description = attributes.getValue("description");
            String dependenciesStr = attributes.getValue("dependencies");
            List<String> authors = authorsStr != null ? Arrays.stream(authorsStr.replaceAll("[\\[\\]]", "").split(",")).map(String::trim).filter(s -> !s.isEmpty()).toList() : Collections.emptyList();
            List<String> list = dependencies = dependenciesStr != null ? Arrays.stream(dependenciesStr.replaceAll("[\\[\\]]", "").split(",")).map(String::trim).filter(s -> !s.isEmpty()).toList() : Collections.emptyList();
            if (name == null || version == null || authors.isEmpty()) {
                this.plugin.getLogger().warning("MANIFEST.MF is missing required fields (name, version, or authors)");
                this.plugin.getLogger().warning(() -> "Name: %s, Version: %s, Authors: %s".formatted(name == null, version == null, authors.isEmpty()));
                AddonMetadata addonMetadata = null;
                return addonMetadata;
            }
            AddonMetadata addonMetadata = new AddonMetadata(name, version, authors, description != null ? description : "", website, dependencies);
            return addonMetadata;
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to load addon metadata from manifest file", e);
            return null;
        }
    }

    protected AddonMetadata loadAddonMetadata() {
        return null;
    }

    public abstract void loadAddons();

    public final void load() {
        if (!this.canLoad()) {
            this.plugin.debug("Skipping loading of addon %s - canLoad() returned false".formatted(this.getAddonMetadata().name()));
            return;
        }
        try {
            this.validateMetadata();
            this.loadAddons();
            this.plugin.getLogger().info("Loaded Addon %s %s by %s".formatted(this.getAddonMetadata().name(), this.getAddonMetadata().version(), this.getAddonMetadata().authors()));
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to load addon %s".formatted(this.getAddonMetadata().name()), e);
        }
    }

    protected void validateMetadata() {
        AddonMetadata meta = this.getAddonMetadata();
        if (meta == null) {
            throw new IllegalStateException("Addon metadata cannot be null");
        }
        if (meta.name() == null || meta.name().isBlank()) {
            throw new IllegalStateException("Addon name cannot be null or blank");
        }
    }

    public abstract boolean canLoad();

    public void unload() {
    }

    public void reload() {
        this.unload();
        this.load();
    }
}

