/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.api.reward;

import com.oheers.fish.api.plugin.EMFPlugin;
import com.oheers.fish.api.registry.EMFRegistry;
import com.oheers.fish.api.reward.RewardType;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RewardTypeRegistry
implements EMFRegistry<RewardType> {
    private static final RewardTypeRegistry instance = new RewardTypeRegistry();
    private final Map<String, RewardType> registry = new TreeMap<String, RewardType>(String.CASE_INSENSITIVE_ORDER);

    private RewardTypeRegistry() {
    }

    @NotNull
    public static RewardTypeRegistry getInstance() {
        return instance;
    }

    @Override
    @NotNull
    public Map<String, RewardType> getRegistry() {
        return Map.copyOf(this.registry);
    }

    @Override
    @Nullable
    public RewardType get(@NotNull String key) {
        return this.registry.get(key);
    }

    @Override
    @NotNull
    public RewardType getOrDefault(@NotNull String key, @NotNull RewardType defaultValue) {
        return this.registry.getOrDefault(key, defaultValue);
    }

    @Override
    public boolean unregister(@NotNull String key) {
        return this.registry.remove(key) != null;
    }

    @Override
    public boolean register(@NotNull RewardType value, boolean force) {
        if (!force && this.registry.containsKey(value.getKey())) {
            return false;
        }
        this.registry.put(value.getKey(), value);
        EMFPlugin.getInstance().debug("Registered " + value.getKey() + " RewardType");
        return true;
    }
}

