/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.commands.admin;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.FishUtils;
import com.oheers.fish.api.config.ConfigBase;
import com.oheers.fish.api.utils.ManifestUtil;
import com.oheers.fish.baits.BaitHandler;
import com.oheers.fish.baits.manager.BaitManager;
import com.oheers.fish.baits.manager.BaitNBTManager;
import com.oheers.fish.commands.BrigCommandUtils;
import com.oheers.fish.commands.CommandUtils;
import com.oheers.fish.commands.HelpMessageBuilder;
import com.oheers.fish.commands.admin.subcommand.CompetitionSubcommand;
import com.oheers.fish.commands.admin.subcommand.DatabaseSubcommand;
import com.oheers.fish.commands.admin.subcommand.FishSubcommand;
import com.oheers.fish.commands.admin.subcommand.ListSubcommand;
import com.oheers.fish.database.Database;
import com.oheers.fish.database.DatabaseUtil;
import com.oheers.fish.fishing.items.FishManager;
import com.oheers.fish.fishing.rods.CustomRod;
import com.oheers.fish.messages.ConfigMessage;
import com.oheers.fish.messages.EMFSingleMessage;
import com.oheers.fish.messages.PrefixType;
import com.oheers.fish.messages.abstracted.EMFMessage;
import com.oheers.fish.utils.nbtapi.NBT;
import dev.dejvokep.boostedyaml.YamlDocument;
import java.util.List;
import java.util.jar.Attributes;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class AdminCommand {
    private static final HelpMessageBuilder HELP_MESSAGE = HelpMessageBuilder.create().addUsage("admin fish", ConfigMessage.HELP_ADMIN_FISH::getMessage).addUsage("admin custom-rod", ConfigMessage.HELP_ADMIN_CUSTOMROD::getMessage).addUsage("admin bait", ConfigMessage.HELP_ADMIN_BAIT::getMessage).addUsage("admin clearbaits", ConfigMessage.HELP_ADMIN_CLEARBAITS::getMessage).addUsage("admin reload", ConfigMessage.HELP_ADMIN_RELOAD::getMessage).addUsage("admin version", ConfigMessage.HELP_ADMIN_VERSION::getMessage).addUsage("admin migrate", ConfigMessage.HELP_ADMIN_MIGRATE::getMessage).addUsage("admin rawItem", ConfigMessage.HELP_ADMIN_RAWITEM::getMessage).addUsage("admin help", ConfigMessage.HELP_GENERAL_HELP::getMessage).addUsage("admin competition", ConfigMessage.HELP_ADMIN_COMPETITION::getMessage);
    DatabaseSubcommand databaseSubcommand;
    FishSubcommand fishSubcommand;
    ListSubcommand listSubcommand;
    CompetitionSubcommand competitionSubcommand;

    public void onDefault(CommandSender sender) {
        AdminCommand.sendHelpMessage(sender);
    }

    public void onCustomRod(CommandSender sender, CustomRod rod, List<Player> targets) throws CommandSyntaxException {
        if (targets.isEmpty()) {
            throw BrigCommandUtils.ERROR_NO_PLAYERS.create();
        }
        ItemStack rodItem = rod.create();
        for (Player player : targets) {
            FishUtils.giveItems(List.of(rodItem), player);
        }
        EMFMessage giveMessage = ConfigMessage.ADMIN_CUSTOM_ROD_GIVEN.getMessage();
        giveMessage.setVariable("{player}", CommandUtils.getPlayersVariable(targets));
        giveMessage.send((Audience)sender);
    }

    public void onCustomRod(CommandSender sender, CustomRod rod) throws CommandSyntaxException {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            this.onCustomRod(sender, rod, List.of(player));
            return;
        }
        ConfigMessage.ADMIN_CANT_BE_CONSOLE.getMessage().send((Audience)sender);
    }

    public void onBait(CommandSender sender, BaitHandler bait, int quantity, List<Player> targets) throws CommandSyntaxException {
        if (targets.isEmpty()) {
            throw BrigCommandUtils.ERROR_NO_PLAYERS.create();
        }
        for (Player target : targets) {
            ItemStack baitItem = bait.create((OfflinePlayer)target);
            baitItem.setAmount(quantity);
            FishUtils.giveItems(List.of(baitItem), target);
        }
        EMFMessage message = ConfigMessage.ADMIN_GIVE_PLAYER_BAIT.getMessage();
        message.setVariable("{player}", CommandUtils.getPlayersVariable(targets));
        message.setBait(bait.getId());
        message.send((Audience)sender);
    }

    public void onBait(CommandSender sender, BaitHandler bait, int quantity) throws CommandSyntaxException {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            this.onBait(sender, bait, quantity, List.of(player));
            return;
        }
        ConfigMessage.ADMIN_CANT_BE_CONSOLE.getMessage().send((Audience)sender);
    }

    public void onBait(CommandSender sender, BaitHandler bait) throws CommandSyntaxException {
        this.onBait(sender, bait, 1);
    }

    public void onClearBaits(CommandSender sender, List<Player> targets) throws CommandSyntaxException {
        if (targets.isEmpty()) {
            throw BrigCommandUtils.ERROR_NO_PLAYERS.create();
        }
        targets.forEach(player -> {
            if (player.getInventory().getItemInMainHand().getType() != Material.FISHING_ROD) {
                ConfigMessage.ADMIN_NOT_HOLDING_ROD.getMessage().send((Audience)player);
                return;
            }
            ItemStack fishingRod = player.getInventory().getItemInMainHand();
            if (!BaitNBTManager.isBaitedRod(fishingRod)) {
                ConfigMessage.NO_BAITS.getMessage().send((Audience)player);
                return;
            }
            int totalDeleted = BaitNBTManager.deleteAllBaits(fishingRod);
            if (totalDeleted > 0) {
                fishingRod.editMeta(meta -> meta.lore(BaitNBTManager.deleteOldLore(fishingRod)));
            }
            EMFMessage message = ConfigMessage.BAITS_CLEARED.getMessage();
            message.setAmount(Integer.toString(totalDeleted));
            message.send((Audience)player);
        });
    }

    public void onClearBaits(CommandSender sender) throws CommandSyntaxException {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            this.onClearBaits(sender, List.of(player));
            return;
        }
        ConfigMessage.ADMIN_CANT_BE_CONSOLE.getMessage().send((Audience)sender);
    }

    public void onReload(CommandSender sender) {
        EvenMoreFish.getInstance().reload(sender);
    }

    public void onVersion(CommandSender sender) {
        int fishCount = FishManager.getInstance().getRarityMap().values().stream().mapToInt(rarity -> rarity.getFishList().size()).sum();
        String databaseEngine = "N/A";
        String databaseType = "N/A";
        Database database = EvenMoreFish.getInstance().getPluginDataManager().getDatabase();
        if (database != null) {
            databaseEngine = database.getDatabaseVersion();
            databaseType = database.getType();
        }
        String msgString = "{prefix} EvenMoreFish by Oheers {version} \n{prefix} Feature Branch: {branch} \n{prefix} Feature Build/Date: {build-date} \n{prefix} MCV: {mcv} \n{prefix} SSV: {ssv} \n{prefix} Online: {online} \n{prefix} Loaded Rarities({rarities}) Fish({fish}) Baits({baits}) Competitions({competitions}) \n{prefix} Database Engine: {engine} \n{prefix} Database Type: {type} \n";
        EMFSingleMessage message = EMFSingleMessage.fromString("{prefix} EvenMoreFish by Oheers {version} \n{prefix} Feature Branch: {branch} \n{prefix} Feature Build/Date: {build-date} \n{prefix} MCV: {mcv} \n{prefix} SSV: {ssv} \n{prefix} Online: {online} \n{prefix} Loaded Rarities({rarities}) Fish({fish}) Baits({baits}) Competitions({competitions}) \n{prefix} Database Engine: {engine} \n{prefix} Database Type: {type} \n");
        message.setVariable("{prefix}", PrefixType.DEFAULT.getPrefix());
        message.setVariable("{version}", EvenMoreFish.getInstance().getPluginMeta().getVersion());
        message.setVariable("{branch}", this.getFeatureBranchName());
        message.setVariable("{build-date}", this.getFeatureBranchBuildOrDate());
        message.setVariable("{mcv}", Bukkit.getServer().getVersion());
        message.setVariable("{ssv}", Bukkit.getServer().getBukkitVersion());
        message.setVariable("{online}", String.valueOf(Bukkit.getServer().getOnlineMode()));
        message.setVariable("{rarities}", String.valueOf(FishManager.getInstance().getRarityMap().size()));
        message.setVariable("{fish}", String.valueOf(fishCount));
        message.setVariable("{baits}", String.valueOf(BaitManager.getInstance().getItemMap().size()));
        message.setVariable("{competitions}", String.valueOf(EvenMoreFish.getInstance().getCompetitionQueue().getSize()));
        message.setVariable("{engine}", databaseEngine);
        message.setVariable("{type}", databaseType);
        message.send((Audience)sender);
    }

    public void onRawItem(CommandSender sender) {
        if (!(sender instanceof Player)) {
            ConfigMessage.ADMIN_CANT_BE_CONSOLE.getMessage().send((Audience)sender);
            return;
        }
        Player player = (Player)sender;
        ItemStack handItem = player.getInventory().getItemInMainHand();
        if (handItem.isEmpty()) {
            return;
        }
        String handItemNbt = NBT.itemStackToNBT(handItem).toString();
        YamlDocument document = new ConfigBase().getConfig();
        document.set("rawItem", (Object)handItemNbt);
        handItemNbt = document.dump().replaceFirst("rawItem: ", "");
        TextComponent.Builder builder = Component.text().content(handItemNbt);
        builder.hoverEvent((HoverEventSource)HoverEvent.hoverEvent((HoverEvent.Action)HoverEvent.Action.SHOW_TEXT, (Object)Component.text((String)"Click to copy to clipboard.")));
        builder.clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.COPY_TO_CLIPBOARD, (String)handItemNbt));
        player.sendMessage((Component)builder.build());
    }

    private String getFeatureBranchName() {
        return ManifestUtil.getAttributeFromManifest(Attributes.Name.IMPLEMENTATION_TITLE.toString(), "main");
    }

    private String getFeatureBranchBuildOrDate() {
        return ManifestUtil.getAttributeFromManifest(Attributes.Name.IMPLEMENTATION_VERSION.toString(), "");
    }

    public void onMigrate(CommandSender sender) {
        if (!DatabaseUtil.isDatabaseOnline()) {
            sender.sendPlainMessage("You cannot run migrations when the database is disabled. Please set database.enabled: true. And restart the server.");
            return;
        }
        EvenMoreFish.getScheduler().runTaskAsynchronously(() -> EvenMoreFish.getInstance().getPluginDataManager().getDatabase().getMigrationManager().migrateLegacy(sender));
    }

    public void onHelp(CommandSender sender) {
        AdminCommand.sendHelpMessage(sender);
    }

    public static void sendHelpMessage(CommandSender sender) {
        HELP_MESSAGE.sendMessage(sender);
    }
}

