/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.commands.admin.subcommand;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.commands.CommandUtils;
import com.oheers.fish.commands.admin.AdminCommand;
import org.bukkit.command.CommandSender;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class DatabaseSubcommand {
    public void onDefault(CommandSender sender) {
        AdminCommand.sendHelpMessage(sender);
    }

    public void onDropFlyway(CommandSender sender) {
        if (CommandUtils.isLogDbError(sender)) {
            return;
        }
        EvenMoreFish.getInstance().getPluginDataManager().getDatabase().getMigrationManager().dropFlywaySchemaHistory();
        sender.sendMessage("Dropped flyway schema history.");
    }

    public void onRepairFlyway(CommandSender sender) {
        if (CommandUtils.isLogDbError(sender)) {
            return;
        }
        sender.sendMessage("Attempting to repair the migrations, check the logs.");
        EvenMoreFish.getInstance().getPluginDataManager().getDatabase().getMigrationManager().repairFlyway();
    }

    public void onCleanFlyway(CommandSender sender) {
        if (CommandUtils.isLogDbError(sender)) {
            return;
        }
        sender.sendMessage("Attempting to clean flyway, check the logs.");
        EvenMoreFish.getInstance().getPluginDataManager().getDatabase().getMigrationManager().cleanFlyway();
    }

    public void onMigrateToLatest(CommandSender sender) {
        if (CommandUtils.isLogDbError(sender)) {
            return;
        }
        EvenMoreFish.getInstance().getPluginDataManager().getDatabase().migrateFromDatabaseVersionToLatest();
    }

    public void onHelp(CommandSender sender) {
        sender.sendMessage("Available Commands: migrate-to-latest, clean-flyway, repair-flyway, drop-flyway");
    }
}

