/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.commands.admin.subcommand;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.oheers.fish.FishUtils;
import com.oheers.fish.commands.BrigCommandUtils;
import com.oheers.fish.commands.CommandUtils;
import com.oheers.fish.commands.admin.AdminCommand;
import com.oheers.fish.commands.arguments.FishArgument;
import com.oheers.fish.fishing.items.Fish;
import com.oheers.fish.fishing.items.Rarity;
import com.oheers.fish.messages.ConfigMessage;
import com.oheers.fish.messages.abstracted.EMFMessage;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class FishSubcommand {
    public void onDefault(CommandSender sender) {
        AdminCommand.sendHelpMessage(sender);
    }

    public void execute(CommandSender sender, Rarity rarity, String fishStr, int amount, List<Player> targets) throws CommandSyntaxException {
        if (targets.isEmpty()) {
            throw BrigCommandUtils.ERROR_NO_PLAYERS.create();
        }
        Fish initialFish = FishArgument.resolveFish(rarity, fishStr);
        if (initialFish == null) {
            throw FishArgument.INVALID_FISH.create((Object)fishStr);
        }
        targets.forEach(target -> {
            Fish fish = initialFish.createCopy();
            fish.init();
            if (fish.hasFishRewards()) {
                fish.getFishRewards().forEach(reward -> reward.rewardPlayer((Player)target, target.getLocation()));
            }
            fish.setFisherman(target.getUniqueId());
            ItemStack fishItem = fish.give();
            fishItem.setAmount(amount);
            FishUtils.giveItem(fishItem, target);
        });
        EMFMessage message = ConfigMessage.ADMIN_GIVE_PLAYER_FISH.getMessage();
        message.setVariable("{player}", CommandUtils.getPlayersVariable(targets));
        message.setFishCaught(initialFish.getName());
        message.send((Audience)sender);
    }

    public void execute(CommandSender sender, Rarity rarity, String fishStr, Integer amount) throws CommandSyntaxException {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            this.execute(sender, rarity, fishStr, amount, List.of(player));
            return;
        }
        ConfigMessage.ADMIN_CANT_BE_CONSOLE.getMessage().send((Audience)sender);
    }

    public void execute(CommandSender sender, Rarity rarity, String fishStr) throws CommandSyntaxException {
        this.execute(sender, rarity, fishStr, 1);
    }
}

