/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.competition;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.api.AbstractFileBasedManager;
import com.oheers.fish.competition.AutoRunner;
import com.oheers.fish.competition.Competition;
import com.oheers.fish.competition.CompetitionType;
import com.oheers.fish.competition.configs.CompetitionConversions;
import com.oheers.fish.competition.configs.CompetitionFile;
import com.oheers.fish.fishing.rods.RodManager;
import java.time.DayOfWeek;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;

public class CompetitionQueue
extends AbstractFileBasedManager<CompetitionFile> {
    private final Map<Integer, Competition> competitions = new TreeMap<Integer, Competition>();

    public CompetitionQueue() {
        super(RodManager.getInstance());
    }

    @Override
    protected void performPreLoadConversions() {
        new CompetitionConversions().performCheck();
    }

    @Override
    protected void loadItems() {
        this.loadItemsFromFiles("competitions", CompetitionFile::new, CompetitionFile::getId, CompetitionFile::isDisabled);
        this.competitions.clear();
        this.getItemMap().values().forEach(file -> {
            Competition competition = new Competition((CompetitionFile)file);
            if (this.loadSpecificDayTimes(competition)) {
                return;
            }
            if (this.loadRepeatedTiming(competition)) {
                return;
            }
            EvenMoreFish.getInstance().debug(Level.WARNING, file.getFile().getName() + "'s timings are not configured properly. This competition will never automatically start.");
        });
    }

    @Override
    protected void logLoadedItems() {
        EvenMoreFish.getInstance().getLogger().info("Loaded " + this.getItemMap().size() + " competition file(s) and " + this.competitions.size() + " scheduled competitions.");
    }

    public Map<Integer, Competition> getCompetitions() {
        return this.competitions;
    }

    private boolean loadSpecificDayTimes(@NotNull Competition competition) {
        Map<DayOfWeek, List<String>> scheduledDays = competition.getCompetitionFile().getScheduledDays();
        if (scheduledDays.isEmpty()) {
            return false;
        }
        scheduledDays.forEach((day, times) -> times.forEach(time -> this.competitions.put(this.generateTimeCode((DayOfWeek)day, (String)time), competition)));
        return true;
    }

    private boolean loadRepeatedTiming(@NotNull Competition competition) {
        CompetitionFile file = competition.getCompetitionFile();
        List<String> repeatedTimes = file.getTimes();
        if (repeatedTimes.isEmpty()) {
            return false;
        }
        ArrayList<DayOfWeek> daysToUse = new ArrayList<DayOfWeek>(Arrays.asList(DayOfWeek.values()));
        daysToUse.removeAll(file.getBlacklistedDays());
        for (String time : repeatedTimes) {
            for (DayOfWeek day : daysToUse) {
                this.competitions.put(this.generateTimeCode(day, time), competition);
            }
        }
        return true;
    }

    public int generateTimeCode(DayOfWeek day, String tfh) {
        int beginning = Arrays.asList(DayOfWeek.values()).indexOf(day) * 24 * 60;
        if (tfh != null) {
            String[] time = tfh.split(":");
            if (time.length != 2) {
                return -1;
            }
            try {
                beginning += Integer.parseInt(time[0]) * 60;
                beginning += Integer.parseInt(time[1]);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return beginning;
    }

    public int getSize() {
        return this.competitions.size();
    }

    public int getNextCompetition() {
        int currentTimeCode = AutoRunner.getCurrentTimeCode();
        if (this.competitions.containsKey(currentTimeCode)) {
            return currentTimeCode;
        }
        Competition competition = new Competition(-1, CompetitionType.LARGEST_FISH);
        this.competitions.put(currentTimeCode, competition);
        int nextTimeCode = this.findNextCompetitionTimeCode(currentTimeCode);
        this.competitions.remove(currentTimeCode);
        return nextTimeCode;
    }

    private int findNextCompetitionTimeCode(int currentTimeCode) {
        ArrayList<Integer> timeCodes = new ArrayList<Integer>(this.competitions.keySet());
        int position = timeCodes.indexOf(currentTimeCode);
        if (position == this.competitions.size() - 1) {
            return (Integer)timeCodes.get(0);
        }
        return (Integer)timeCodes.get(position + 1);
    }
}

