/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.database.model.fish;

import com.oheers.fish.fishing.items.Fish;
import java.time.LocalDateTime;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class FishStats {
    @NotNull
    private final String fishName;
    @NotNull
    private final String fishRarity;
    @NotNull
    private final LocalDateTime firstCatchTime;
    @NotNull
    private final UUID discoverer;
    private float shortestLength;
    @NotNull
    private UUID shortestFisher;
    private float longestLength;
    @NotNull
    private UUID longestFisher;
    private int quantity;

    public FishStats(@NotNull String fishName, @NotNull String fishRarity, @NotNull LocalDateTime firstCatchTime, @NotNull UUID discoverer, float shortestLength, @NotNull UUID shortestFisher, float longestLength, @NotNull UUID longestFisher, int quantity) {
        this.fishName = fishName;
        this.fishRarity = fishRarity;
        this.firstCatchTime = firstCatchTime;
        this.discoverer = discoverer;
        this.shortestLength = shortestLength;
        this.shortestFisher = shortestFisher;
        this.longestLength = longestLength;
        this.longestFisher = longestFisher;
        this.quantity = quantity;
    }

    public FishStats(Fish fish, @NotNull LocalDateTime firstCatchTime, @NotNull UUID discoverer, float shortestLength, @NotNull UUID shortestFisher, float longestLength, @NotNull UUID longestFisher, int quantity) {
        this.fishName = fish.getName();
        this.fishRarity = fish.getRarity().getId();
        this.firstCatchTime = firstCatchTime;
        this.discoverer = discoverer;
        this.shortestLength = shortestLength;
        this.shortestFisher = shortestFisher;
        this.longestLength = longestLength;
        this.longestFisher = longestFisher;
        this.quantity = quantity;
    }

    public static FishStats empty(Fish fish, LocalDateTime firstCatchTime) {
        return new FishStats(fish, firstCatchTime, fish.getFisherman(), fish.getLength(), fish.getFisherman(), fish.getLength(), fish.getFisherman(), 0);
    }

    @NotNull
    public String getFishName() {
        return this.fishName;
    }

    @NotNull
    public String getFishRarity() {
        return this.fishRarity;
    }

    @NotNull
    public LocalDateTime getFirstCatchTime() {
        return this.firstCatchTime;
    }

    public float getShortestLength() {
        return this.shortestLength;
    }

    @NotNull
    public UUID getShortestFisher() {
        return this.shortestFisher;
    }

    public float getLongestLength() {
        return this.longestLength;
    }

    @NotNull
    public UUID getLongestFisher() {
        return this.longestFisher;
    }

    public int getQuantity() {
        return this.quantity;
    }

    @NotNull
    public UUID getDiscoverer() {
        return this.discoverer;
    }

    public void setShortestLength(float shortestLength) {
        this.shortestLength = shortestLength;
    }

    public void setShortestFisher(@NotNull UUID shortestFisher) {
        this.shortestFisher = shortestFisher;
    }

    public void setLongestLength(float longestLength) {
        this.longestLength = longestLength;
    }

    public void setLongestFisher(@NotNull UUID longestFisher) {
        this.longestFisher = longestFisher;
    }

    public void incrementQuantity() {
        ++this.quantity;
    }

    public void incrementQuantity(int quantity) {
        this.quantity += quantity;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    public String toString() {
        return "FishStats{fishName='" + this.fishName + "', fishRarity='" + this.fishRarity + "', firstCatchTime=" + String.valueOf(this.firstCatchTime) + ", discoverer=" + String.valueOf(this.discoverer) + ", shortestLength=" + this.shortestLength + ", shortestFisher=" + String.valueOf(this.shortestFisher) + ", longestLength=" + this.longestLength + ", longestFisher=" + String.valueOf(this.longestFisher) + ", quantity=" + this.quantity + "}";
    }
}

