/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.items;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.FishUtils;
import com.oheers.fish.api.config.ConfigUtils;
import com.oheers.fish.items.ItemFactoryConversion;
import com.oheers.fish.items.configs.CustomModelDataItemConfig;
import com.oheers.fish.items.configs.DisplayNameItemConfig;
import com.oheers.fish.items.configs.DyeColourItemConfig;
import com.oheers.fish.items.configs.EnchantmentsItemConfig;
import com.oheers.fish.items.configs.GlowingItemConfig;
import com.oheers.fish.items.configs.ItemDamageItemConfig;
import com.oheers.fish.items.configs.LoreItemConfig;
import com.oheers.fish.items.configs.PotionMetaItemConfig;
import com.oheers.fish.items.configs.QuantityItemConfig;
import com.oheers.fish.items.configs.UnbreakableItemConfig;
import com.oheers.fish.utils.ItemUtils;
import com.oheers.fish.utils.nbtapi.NBT;
import com.oheers.fish.utils.nbtapi.NbtApiException;
import dev.dejvokep.boostedyaml.block.implementation.Section;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import me.arcaniax.hdb.api.HeadDatabaseAPI;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemFactory {
    @NotNull
    private final Section configuration;
    private boolean rawItem = false;
    private UUID relevantPlayer = null;
    private int randomIndex = -1;
    private Consumer<ItemStack> finalChanges = null;
    @NotNull
    private ItemStack baseItem;
    private final CustomModelDataItemConfig customModelData;
    private final ItemDamageItemConfig itemDamage;
    private final DisplayNameItemConfig displayName;
    private final DyeColourItemConfig dyeColour;
    private final GlowingItemConfig glowing;
    private final LoreItemConfig lore;
    private final PotionMetaItemConfig potionMeta;
    private final EnchantmentsItemConfig enchantments;
    private final UnbreakableItemConfig unbreakable;
    private final QuantityItemConfig quantity;

    private ItemFactory(@NotNull Section initialSection, @Nullable String configLocation) {
        this.configuration = configLocation == null ? initialSection : ConfigUtils.getOrCreateSection(initialSection, configLocation);
        new ItemFactoryConversion().performConversions(this.configuration);
        this.customModelData = new CustomModelDataItemConfig(this.configuration);
        this.itemDamage = new ItemDamageItemConfig(this.configuration);
        this.displayName = new DisplayNameItemConfig(this.configuration);
        this.dyeColour = new DyeColourItemConfig(this.configuration);
        this.glowing = new GlowingItemConfig(this.configuration);
        this.lore = new LoreItemConfig(this.configuration);
        this.potionMeta = new PotionMetaItemConfig(this.configuration);
        this.enchantments = new EnchantmentsItemConfig(this.configuration);
        this.unbreakable = new UnbreakableItemConfig(this.configuration);
        this.quantity = new QuantityItemConfig(this.configuration);
        this.baseItem = this.getBaseItem();
    }

    public static ItemFactory itemFactory(@NotNull Section configuration) {
        return new ItemFactory(configuration, null);
    }

    public static ItemFactory itemFactory(@NotNull Section configuration, @NotNull String configLocation) {
        return new ItemFactory(configuration, configLocation);
    }

    @NotNull
    public ItemStack createItem() {
        return this.createItem((Map)null);
    }

    @NotNull
    public ItemStack createItem(@Nullable Map<String, ?> replacements) {
        ItemStack item = this.baseItem.clone();
        if (!this.rawItem) {
            this.customModelData.apply(item, replacements);
            this.itemDamage.apply(item, replacements);
            this.displayName.apply(item, replacements);
            this.dyeColour.apply(item, replacements);
            this.glowing.apply(item, replacements);
            this.lore.apply(item, replacements);
            this.potionMeta.apply(item, replacements);
            this.enchantments.apply(item, replacements);
            this.unbreakable.apply(item, replacements);
            this.quantity.apply(item, replacements);
            if (this.finalChanges != null) {
                this.finalChanges.accept(item);
            }
        }
        return item;
    }

    @NotNull
    public ItemStack createItem(@NotNull UUID relevantPlayer) {
        this.relevantPlayer = relevantPlayer;
        return this.createItem();
    }

    @NotNull
    public ItemStack createItem(@NotNull UUID relevantPlayer, @Nullable Map<String, ?> replacements) {
        this.relevantPlayer = relevantPlayer;
        return this.createItem(replacements);
    }

    @NotNull
    public ItemStack getBaseItem() {
        ItemStack rawNbt = this.checkRawNbt();
        if (rawNbt != null) {
            this.rawItem = true;
            return rawNbt;
        }
        ItemStack material = this.checkMaterial();
        if (material != null) {
            return material;
        }
        ItemStack rawMaterial = this.checkRawMaterial();
        if (rawMaterial != null) {
            this.rawItem = true;
            return rawMaterial;
        }
        ItemStack randomMaterial = this.checkRandomMaterial();
        if (randomMaterial != null) {
            return randomMaterial;
        }
        ItemStack headDB = this.checkHeadDB();
        if (headDB != null) {
            return headDB;
        }
        ItemStack randomHeadDB = this.checkRandomHeadDB();
        if (randomHeadDB != null) {
            return randomHeadDB;
        }
        ItemStack head64 = this.checkHead64();
        if (head64 != null) {
            return head64;
        }
        ItemStack randomHead64 = this.checkRandomHead64();
        if (randomHead64 != null) {
            return randomHead64;
        }
        ItemStack headUUID = this.checkHeadUUID();
        if (headUUID != null) {
            return headUUID;
        }
        ItemStack randomHeadUUID = this.checkRandomHeadUUID();
        if (randomHeadUUID != null) {
            return randomHeadUUID;
        }
        ItemStack ownHead = this.checkOwnHead();
        if (ownHead != null) {
            return ownHead;
        }
        EvenMoreFish.getInstance().debug(this.configuration.getRouteAsString() + " has no valid item, returning default.");
        return new ItemStack(Material.COD);
    }

    public CustomModelDataItemConfig getCustomModelData() {
        return this.customModelData;
    }

    public ItemDamageItemConfig getItemDamage() {
        return this.itemDamage;
    }

    public DisplayNameItemConfig getDisplayName() {
        return this.displayName;
    }

    public DyeColourItemConfig getDyeColour() {
        return this.dyeColour;
    }

    public GlowingItemConfig getGlowing() {
        return this.glowing;
    }

    public LoreItemConfig getLore() {
        return this.lore;
    }

    public PotionMetaItemConfig getPotionMeta() {
        return this.potionMeta;
    }

    public EnchantmentsItemConfig getEnchantments() {
        return this.enchantments;
    }

    public UnbreakableItemConfig getUnbreakable() {
        return this.unbreakable;
    }

    public QuantityItemConfig getQuantity() {
        return this.quantity;
    }

    @Nullable
    private ItemStack checkRawNbt() {
        String rawValue = this.configuration.getString("item.raw-nbt");
        if (rawValue == null) {
            return null;
        }
        try {
            return NBT.itemStackFromNBT(NBT.parseNBT(rawValue));
        }
        catch (NbtApiException exception) {
            EvenMoreFish.getInstance().getLogger().severe(this.configuration.getRouteAsString() + " has invalid raw NBT: " + rawValue);
            return null;
        }
    }

    @Nullable
    private ItemStack getItemFromMaterialString(@NotNull String materialString) {
        Material material = ItemUtils.getMaterial(materialString);
        if (material != null) {
            return new ItemStack(material);
        }
        EvenMoreFish.getInstance().debug(materialString + " is not a valid material, checking for custom item.");
        ItemStack customItem = FishUtils.getItem(materialString);
        if (customItem != null) {
            return customItem;
        }
        EvenMoreFish.getInstance().getLogger().severe("Could not find material or custom item for: " + materialString);
        return null;
    }

    @Nullable
    private ItemStack checkMaterial() {
        String materialStr = this.configuration.getString("item.material");
        if (materialStr == null) {
            return null;
        }
        return this.getItemFromMaterialString(materialStr);
    }

    @Nullable
    private ItemStack checkRandomMaterial() {
        ArrayList<String> materialStrs = new ArrayList<String>(this.configuration.getStringList("item.materials"));
        if (materialStrs.isEmpty()) {
            return null;
        }
        if (materialStrs.size() == 1) {
            return this.getItemFromMaterialString((String)materialStrs.get(0));
        }
        return this.getRandomItem(materialStrs, this::getItemFromMaterialString);
    }

    @Nullable
    private ItemStack checkRawMaterial() {
        String materialStr = this.configuration.getString("item.raw-material");
        if (materialStr == null) {
            return null;
        }
        return this.getItemFromMaterialString(materialStr);
    }

    @Nullable
    private ItemStack checkHeadDB() {
        if (!EvenMoreFish.getInstance().getDependencyManager().isUsingHeadsDB()) {
            return null;
        }
        String materialStr = this.configuration.getString("item.headdb");
        if (materialStr == null) {
            return null;
        }
        ItemStack item = EvenMoreFish.getInstance().getDependencyManager().getHdbapi().getItemHead(materialStr);
        if (item == null) {
            EvenMoreFish.getInstance().debug(this.configuration.getRouteAsString() + " has invalid headdb: " + materialStr);
            return null;
        }
        return item;
    }

    @Nullable
    private ItemStack checkRandomHeadDB() {
        if (!EvenMoreFish.getInstance().getDependencyManager().isUsingHeadsDB()) {
            return null;
        }
        ArrayList<String> materialStrs = new ArrayList<String>(this.configuration.getStringList("item.multiple-headdb"));
        if (materialStrs.isEmpty()) {
            return null;
        }
        if (materialStrs.size() == 1) {
            return EvenMoreFish.getInstance().getDependencyManager().getHdbapi().getItemHead((String)materialStrs.get(0));
        }
        return this.getRandomItem(materialStrs, arg_0 -> ((HeadDatabaseAPI)EvenMoreFish.getInstance().getDependencyManager().getHdbapi()).getItemHead(arg_0));
    }

    @Nullable
    private ItemStack checkHead64() {
        String materialStr = this.configuration.getString("item.head-64");
        if (materialStr == null) {
            return null;
        }
        return FishUtils.getSkullFromBase64(materialStr);
    }

    @Nullable
    private ItemStack checkRandomHead64() {
        ArrayList<String> materialStrs = new ArrayList<String>(this.configuration.getStringList("item.multiple-head-64"));
        if (materialStrs.isEmpty()) {
            return null;
        }
        if (materialStrs.size() == 1) {
            return FishUtils.getSkullFromBase64((String)materialStrs.get(0));
        }
        return this.getRandomItem(materialStrs, FishUtils::getSkullFromBase64);
    }

    @Nullable
    private ItemStack checkHeadUUID() {
        String materialStr = this.configuration.getString("item.head-uuid");
        if (materialStr == null) {
            return null;
        }
        return FishUtils.getSkullFromUUIDString(materialStr);
    }

    @Nullable
    private ItemStack checkRandomHeadUUID() {
        ArrayList<String> materialStrs = new ArrayList<String>(this.configuration.getStringList("item.multiple-head-uuid"));
        if (materialStrs.isEmpty()) {
            return null;
        }
        if (materialStrs.size() == 1) {
            return FishUtils.getSkullFromUUIDString((String)materialStrs.get(0));
        }
        return this.getRandomItem(materialStrs, FishUtils::getSkullFromUUIDString);
    }

    @Nullable
    private ItemStack checkOwnHead() {
        if (this.relevantPlayer == null) {
            return null;
        }
        String materialStr = this.configuration.getString("item.own-head");
        if (materialStr == null) {
            return null;
        }
        return FishUtils.getSkullFromUUID(this.relevantPlayer);
    }

    @Nullable
    private ItemStack getRandomItem(@NotNull List<String> strings, @NotNull Function<String, ItemStack> function) {
        if (this.randomIndex != -1) {
            EvenMoreFish.getInstance().debug("Random index is set to " + this.randomIndex + ", trying to use it.");
            try {
                String randomStr = strings.get(this.randomIndex);
                ItemStack randomItem = function.apply(randomStr);
                if (randomItem != null) {
                    return randomItem;
                }
            }
            catch (IndexOutOfBoundsException exception) {
                EvenMoreFish.getInstance().debug("Random index " + this.randomIndex + " is out of bounds, getting a new one.");
            }
        }
        ArrayList<String> checkList = new ArrayList<String>(strings);
        Random random = EvenMoreFish.getInstance().getRandom();
        while (!checkList.isEmpty()) {
            int randomIndex = random.nextInt(checkList.size());
            String randomStr = checkList.remove(randomIndex);
            ItemStack randomItem = function.apply(randomStr);
            if (randomItem != null) {
                this.randomIndex = randomIndex;
                return randomItem;
            }
            EvenMoreFish.getInstance().debug(this.configuration.getRouteAsString() + " has an invalid name in its list: " + randomStr);
        }
        EvenMoreFish.getInstance().debug(this.configuration.getRouteAsString() + " has no valid items in its list.");
        return null;
    }

    public boolean isRawItem() {
        return this.rawItem;
    }

    public void setRandomIndex(int randomIndex) {
        this.randomIndex = randomIndex;
        this.baseItem = this.getBaseItem();
    }

    public int getRandomIndex() {
        return this.randomIndex;
    }

    public void setFinalChanges(@Nullable Consumer<ItemStack> finalChanges) {
        this.finalChanges = finalChanges;
    }
}

