/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.items.configs;

import com.oheers.fish.items.configs.ItemConfig;
import dev.dejvokep.boostedyaml.block.implementation.Section;
import java.awt.Color;
import java.util.Map;
import java.util.function.BiConsumer;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DyeColourItemConfig
extends ItemConfig<org.bukkit.Color> {
    public DyeColourItemConfig(@NotNull Section section) {
        super(section);
    }

    @Override
    public org.bukkit.Color getConfiguredValue() {
        String colourString = this.section.getString("item.dye-colour");
        if (colourString == null) {
            return null;
        }
        try {
            Color color = Color.decode(colourString);
            return org.bukkit.Color.fromRGB((int)color.getRed(), (int)color.getGreen(), (int)color.getBlue());
        }
        catch (NumberFormatException exception) {
            return null;
        }
    }

    @Override
    protected BiConsumer<ItemStack, org.bukkit.Color> applyToItem(@Nullable Map<String, ?> replacements) {
        return (item, value) -> {
            if (value == null) {
                return;
            }
            item.editMeta(LeatherArmorMeta.class, meta -> {
                meta.setColor(value);
                meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
            });
        };
    }
}

