/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Asterisk;
import com.oheers.fish.libs.jooq.Configuration;
import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.DMLQuery;
import com.oheers.fish.libs.jooq.DSLContext;
import com.oheers.fish.libs.jooq.DataType;
import com.oheers.fish.libs.jooq.Delete;
import com.oheers.fish.libs.jooq.ExecuteContext;
import com.oheers.fish.libs.jooq.ExecuteListener;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.Identity;
import com.oheers.fish.libs.jooq.Insert;
import com.oheers.fish.libs.jooq.QualifiedAsterisk;
import com.oheers.fish.libs.jooq.Record;
import com.oheers.fish.libs.jooq.Result;
import com.oheers.fish.libs.jooq.Row;
import com.oheers.fish.libs.jooq.SQLDialect;
import com.oheers.fish.libs.jooq.Scope;
import com.oheers.fish.libs.jooq.SelectFieldOrAsterisk;
import com.oheers.fish.libs.jooq.Table;
import com.oheers.fish.libs.jooq.TableLike;
import com.oheers.fish.libs.jooq.Update;
import com.oheers.fish.libs.jooq.conf.ExecuteWithoutWhere;
import com.oheers.fish.libs.jooq.conf.FetchTriggerValuesAfterReturning;
import com.oheers.fish.libs.jooq.conf.RenderNameCase;
import com.oheers.fish.libs.jooq.conf.SettingsTools;
import com.oheers.fish.libs.jooq.exception.DataAccessException;
import com.oheers.fish.libs.jooq.impl.AbstractQuery;
import com.oheers.fish.libs.jooq.impl.AbstractRecord;
import com.oheers.fish.libs.jooq.impl.AbstractRow;
import com.oheers.fish.libs.jooq.impl.AbstractRowCountQuery;
import com.oheers.fish.libs.jooq.impl.CommonTableExpressionList;
import com.oheers.fish.libs.jooq.impl.CursorImpl;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.DataChangeDeltaTable;
import com.oheers.fish.libs.jooq.impl.DefaultExecuteContext;
import com.oheers.fish.libs.jooq.impl.DeleteQueryImpl;
import com.oheers.fish.libs.jooq.impl.FieldsImpl;
import com.oheers.fish.libs.jooq.impl.Keywords;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.ResultImpl;
import com.oheers.fish.libs.jooq.impl.RowAsField;
import com.oheers.fish.libs.jooq.impl.SelectFieldList;
import com.oheers.fish.libs.jooq.impl.TableAsField;
import com.oheers.fish.libs.jooq.impl.ThrowingSupplier;
import com.oheers.fish.libs.jooq.impl.Tools;
import com.oheers.fish.libs.jooq.impl.WithImpl;
import com.oheers.fish.libs.jooq.tools.JooqLogger;
import com.oheers.fish.libs.jooq.tools.StringUtils;
import com.oheers.fish.libs.jooq.tools.jdbc.JDBCUtils;
import com.oheers.fish.libs.jooq.util.sqlite.SQLiteDSL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;

abstract class AbstractDMLQuery<R extends Record>
extends AbstractRowCountQuery
implements DMLQuery<R> {
    private static final JooqLogger log = JooqLogger.getLogger(AbstractQuery.class);
    private static final Set<SQLDialect> NO_NATIVE_SUPPORT_INSERT_RETURNING = SQLDialect.supportedUntil(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.IGNITE, SQLDialect.MYSQL, SQLDialect.TRINO);
    private static final Set<SQLDialect> NO_NATIVE_SUPPORT_UPDATE_RETURNING = SQLDialect.supportedUntil(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.IGNITE, SQLDialect.MYSQL, SQLDialect.TRINO);
    private static final Set<SQLDialect> NO_NATIVE_SUPPORT_DELETE_RETURNING = SQLDialect.supportedUntil(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.IGNITE, SQLDialect.MYSQL, SQLDialect.TRINO);
    private static final Set<SQLDialect> NATIVE_SUPPORT_DATA_CHANGE_DELTA_TABLE = SQLDialect.supportedBy(SQLDialect.H2);
    private static final Set<SQLDialect> NO_SUPPORT_FETCHING_KEYS = SQLDialect.supportedBy(SQLDialect.IGNITE, SQLDialect.TRINO);
    private static final Set<SQLDialect> NO_SUPPORT_RETURNING_ASTERISK = SQLDialect.supportedUntil(SQLDialect.MARIADB);
    final WithImpl with;
    final Table<R> table;
    final SelectFieldList<SelectFieldOrAsterisk> returning;
    final List<Field<?>> returningResolvedAsterisks;
    Result<Record> returnedResult;
    Result<R> returned;

    AbstractDMLQuery(Configuration configuration, WithImpl with, Table<R> table) {
        super(configuration);
        this.with = with;
        this.table = table;
        this.returning = new SelectFieldList();
        this.returningResolvedAsterisks = new ArrayList();
    }

    public final void setReturning() {
        this.setReturning(this.table.fields());
    }

    public final void setReturning(Identity<R, ?> identity) {
        if (identity != null) {
            this.setReturning(identity.getField());
        }
    }

    public final void setReturning(SelectFieldOrAsterisk ... fields) {
        this.setReturning(Arrays.asList(fields));
    }

    public final void setReturning(Collection<? extends SelectFieldOrAsterisk> fields) {
        this.returning.clear();
        this.returning.addAll(fields.isEmpty() ? Arrays.asList(this.table.fields()) : fields);
        this.returningResolvedAsterisks.clear();
        for (SelectFieldOrAsterisk s : this.returning) {
            if (s instanceof Field) {
                Field f = (Field)s;
                this.returningResolvedAsterisks.add(f);
                continue;
            }
            if (s instanceof QualifiedAsterisk) {
                QualifiedAsterisk a = (QualifiedAsterisk)s;
                this.returningResolvedAsterisks.addAll(Arrays.asList(a.qualifier().fields()));
                continue;
            }
            if (s instanceof Asterisk) {
                this.returningResolvedAsterisks.addAll(Arrays.asList(this.table.fields()));
                continue;
            }
            if (s instanceof Row) {
                Row r = (Row)((Object)s);
                this.returningResolvedAsterisks.add(new RowAsField(r));
                continue;
            }
            if (s instanceof Table) {
                Table t = (Table)s;
                this.returningResolvedAsterisks.add(new TableAsField(t));
                continue;
            }
            throw new UnsupportedOperationException("Type not supported: " + String.valueOf(s));
        }
    }

    public final R getReturnedRecord() {
        if (this.getReturnedRecords().isEmpty()) {
            return null;
        }
        return (R)((Record)this.getReturnedRecords().get(0));
    }

    public final Result<R> getReturnedRecords() {
        if (this.returned == null) {
            if (this.table.fields().length > 0) {
                this.warnOnAPIMisuse();
                this.returned = this.getResult().into(this.table);
            } else {
                this.returned = this.getResult();
            }
        }
        return this.returned;
    }

    private final void warnOnAPIMisuse() {
        for (Field<?> field : this.getResult().fields()) {
            if (this.table.field(field) != null) continue;
            log.warn((Object)"API misuse", "Column " + String.valueOf(field) + " has been requested through the returning() clause, which is not present in table " + String.valueOf(this.table) + ". Use StoreQuery.getResult() or the returningResult() clause instead.");
        }
    }

    final Table<R> table() {
        return this.table;
    }

    final Table<?> table(Scope ctx) {
        return this.table();
    }

    public final Result<?> getResult() {
        if (this.returnedResult == null) {
            this.returnedResult = new ResultImpl<Record>(this.configuration(), this.returningResolvedAsterisks);
        }
        return this.returnedResult;
    }

    final void accept0(Context<?> ctx) {
        QOM.UnmodifiableList<Table<?>> unmodifiableList;
        WithImpl w = this.with;
        ctx.data(Tools.SimpleDataKey.DATA_DML_TARGET_TABLE, this.table);
        AbstractDMLQuery abstractDMLQuery = this;
        if (abstractDMLQuery instanceof DeleteQueryImpl) {
            DeleteQueryImpl d = (DeleteQueryImpl)abstractDMLQuery;
            unmodifiableList = d.$using();
        } else {
            unmodifiableList = null;
        }
        ctx.data(Tools.SimpleDataKey.DATA_DML_USING_TABLES, unmodifiableList);
        if (w != null) {
            ctx.visit(w);
        } else {
            CommonTableExpressionList.markTopLevelCteAndAccept(ctx, c -> {});
        }
        boolean previousDeclareFields = ctx.declareFields();
        if (NATIVE_SUPPORT_DATA_CHANGE_DELTA_TABLE.contains((Object)ctx.dialect()) && !this.returning.isEmpty() && ctx.data(Tools.SimpleDataKey.DATA_RENDERING_DATA_CHANGE_DELTA_TABLE) == null) {
            Tools.increment(ctx.data(), Tools.SimpleDataKey.DATA_RENDERING_DATA_CHANGE_DELTA_TABLE, () -> ctx.visit(DSL.select(this.returning).from((TableLike<?>)((Object)new DataChangeDeltaTable(this instanceof Delete ? QOM.ResultOption.OLD : QOM.ResultOption.FINAL, this).as(this.table().getUnqualifiedName())))));
        } else {
            this.accept1(ctx);
        }
        ctx.data().remove(Tools.SimpleDataKey.DATA_DML_USING_TABLES);
        ctx.data().remove(Tools.SimpleDataKey.DATA_DML_TARGET_TABLE);
    }

    private final boolean fetchTriggerValuesAfterReturning(Scope ctx) {
        if (this instanceof Delete) {
            return false;
        }
        if (Boolean.FALSE.equals(ctx.settings().isFetchTriggerValuesAfterSQLServerOutput())) {
            return false;
        }
        switch (StringUtils.defaultIfNull(ctx.settings().getFetchTriggerValuesAfterReturning(), FetchTriggerValuesAfterReturning.WHEN_NEEDED)) {
            case ALWAYS: {
                return true;
            }
            case NEVER: {
                return false;
            }
            case WHEN_NEEDED: {
                if (ctx.configuration().commercial()) {
                    // empty if block
                }
                return true;
            }
        }
        throw new IllegalStateException("Unsupported value: " + String.valueOf((Object)ctx.settings().getFetchTriggerValuesAfterReturning()));
    }

    abstract void accept1(Context<?> var1);

    void executeWithoutWhere(String message, ExecuteWithoutWhere executeWithoutWhere) {
        switch (executeWithoutWhere) {
            case IGNORE: {
                break;
            }
            case LOG_DEBUG: {
                if (!log.isDebugEnabled()) break;
                log.debug((Object)message, "A statement is executed without WHERE clause");
                break;
            }
            case LOG_INFO: {
                if (!log.isInfoEnabled()) break;
                log.info((Object)message, "A statement is executed without WHERE clause");
                break;
            }
            case LOG_WARN: {
                log.warn((Object)message, "A statement is executed without WHERE clause");
                break;
            }
            case THROW: {
                throw new DataAccessException("A statement is executed without WHERE clause");
            }
        }
    }

    final void toSQLReturning(Context<?> ctx) {
        if (!this.returning.isEmpty() && this.nativeSupportReturning(ctx)) {
            boolean unqualify;
            boolean qualify = ctx.qualify();
            boolean bl = unqualify = ctx.family() == SQLDialect.MARIADB;
            if (unqualify) {
                ctx.qualify(false);
            }
            ctx.formatSeparator().visit(Keywords.K_RETURNING).sql(' ').declareFields(true, c -> c.visit(NO_SUPPORT_RETURNING_ASTERISK.contains((Object)c.dialect()) ? new SelectFieldList<SelectFieldOrAsterisk>((Iterable<SelectFieldOrAsterisk>)this.returningResolvedAsterisks) : this.returning));
            if (unqualify) {
                ctx.qualify(qualify);
            }
        }
    }

    final boolean nativeSupportReturning(Scope ctx) {
        return (ctx.family() != SQLDialect.SQLITE || !(this instanceof Insert) || !this.fetchTriggerValuesAfterReturning(ctx)) && (this instanceof Insert && !NO_NATIVE_SUPPORT_INSERT_RETURNING.contains((Object)ctx.dialect()) || this instanceof Update && !NO_NATIVE_SUPPORT_UPDATE_RETURNING.contains((Object)ctx.dialect()) || this instanceof Delete && !NO_NATIVE_SUPPORT_DELETE_RETURNING.contains((Object)ctx.dialect()));
    }

    final boolean nativeSupportReturningOrDataChangeDeltaTable(Scope ctx) {
        return NATIVE_SUPPORT_DATA_CHANGE_DELTA_TABLE.contains((Object)ctx.dialect()) || this.nativeSupportReturning(ctx);
    }

    @Override
    protected final void prepare(ExecuteContext ctx) throws SQLException {
        this.prepare0(ctx);
        Tools.setFetchSize(ctx, 0);
    }

    private final void prepare0(ExecuteContext ctx) throws SQLException {
        Connection connection = ctx.connection();
        if (this.returning.isEmpty()) {
            super.prepare(ctx);
        } else if (NO_SUPPORT_FETCHING_KEYS.contains((Object)ctx.dialect())) {
            super.prepare(ctx);
        } else if (this.nativeSupportReturningOrDataChangeDeltaTable(ctx)) {
            super.prepare(ctx);
        } else {
            switch (ctx.family()) {
                case SQLITE: 
                case CUBRID: {
                    super.prepare(ctx);
                    break;
                }
                case DERBY: 
                case MARIADB: 
                case MYSQL: {
                    if (ctx.statement() != null) break;
                    ctx.statement(connection.prepareStatement(ctx.sql(), 1));
                    break;
                }
                default: {
                    if (ctx.statement() != null) break;
                    RenderNameCase style = SettingsTools.getRenderNameCase(this.configuration().settings());
                    ctx.statement(connection.prepareStatement(ctx.sql(), Tools.map(Tools.flattenCollection(this.returningResolvedAsterisks, false, true), style == RenderNameCase.UPPER ? f -> f.getName().toUpperCase(SettingsTools.renderLocale(this.configuration().settings())) : (style == RenderNameCase.LOWER ? f -> f.getName().toLowerCase(SettingsTools.renderLocale(this.configuration().settings())) : f -> f.getName())).toArray(Tools.EMPTY_STRING)));
                }
            }
        }
    }

    @Override
    protected final int execute(ExecuteContext ctx, ExecuteListener listener) throws SQLException {
        this.returned = null;
        this.returnedResult = null;
        if (this.returning.isEmpty()) {
            return super.execute(ctx, listener);
        }
        if (NO_SUPPORT_FETCHING_KEYS.contains((Object)ctx.dialect())) {
            log.debug("RETURNING was set on query, but dialect doesn't support fetching generated keys: " + String.valueOf((Object)ctx.dialect()));
            return super.execute(ctx, listener);
        }
        int result = 0;
        switch (ctx.family()) {
            case SQLITE: {
                if (!this.nativeSupportReturning(ctx)) {
                    listener.executeStart(ctx);
                    result = this.executeImmediate(ctx.statement()).executeUpdate();
                    ctx.rows(result);
                    listener.executeEnd(ctx);
                    DSLContext create = ctx.dsl();
                    this.returnedResult = create.select(this.returning).from((TableLike<?>)this.table).where(SQLiteDSL.rowid().eq(DSL.field("last_insert_rowid()", SQLiteDSL.rowid().getDataType()))).fetch();
                    this.returnedResult.attach(((DefaultExecuteContext)ctx).originalConfiguration());
                    this.logOnEmptyReturned(ctx);
                    return result;
                }
                this.executeReturningQuery(ctx, listener);
                break;
            }
            case CUBRID: {
                listener.executeStart(ctx);
                result = this.executeImmediate(ctx.statement()).executeUpdate();
                ctx.rows(result);
                listener.executeEnd(ctx);
                this.selectReturning(((DefaultExecuteContext)ctx).originalConfiguration(), ctx.configuration(), ctx.dsl().lastID());
                return result;
            }
            case DERBY: 
            case MYSQL: {
                return this.executeReturningGeneratedKeysFetchAdditionalRows(ctx, listener);
            }
            case MARIADB: {
                if (!this.nativeSupportReturning(ctx)) {
                    return this.executeReturningGeneratedKeysFetchAdditionalRows(ctx, listener);
                }
                this.executeReturningQuery(ctx, listener);
                break;
            }
            case H2: {
                this.executeReturningQuery(ctx, listener);
                break;
            }
            case DUCKDB: 
            case FIREBIRD: 
            case POSTGRES: 
            case YUGABYTEDB: {
                this.executeReturningQuery(ctx, listener);
                break;
            }
            default: {
                result = this.executeReturningGeneratedKeys(ctx, listener);
            }
        }
        this.returnedResult = new CursorImpl(ctx, listener, this.returningResolvedAsterisks.toArray(Tools.EMPTY_FIELD), null, false, false).fetch();
        if (!this.returnedResult.isEmpty() || ctx.family() != SQLDialect.HSQLDB) {
            result = Math.max(Math.max(result, ctx.rows()), this.returnedResult.size());
            ctx.rows(result);
        }
        return result;
    }

    private final void logOnEmptyReturned(Scope ctx) {
        if (this.estimatedRowCount(ctx) == 1) {
            log.debug("RETURNING was set on query, but no rows were returned. This is likely due to a missing identity column (or an identity column unknown to jOOQ).");
        }
    }

    abstract int estimatedRowCount(Scope var1);

    private final int executeReturningGeneratedKeys(ExecuteContext ctx, ExecuteListener listener) throws SQLException {
        listener.executeStart(ctx);
        int result = this.executeImmediate(ctx.statement()).executeUpdate();
        ctx.rows(result);
        ctx.resultSet(ctx.statement().getGeneratedKeys());
        listener.executeEnd(ctx);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int executeReturningGeneratedKeysFetchAdditionalRows(ExecuteContext ctx, ExecuteListener listener) throws SQLException {
        listener.executeStart(ctx);
        int result = this.executeImmediate(ctx.statement()).executeUpdate();
        ctx.rows(result);
        listener.executeEnd(ctx);
        ResultSet rs = ctx.statement().getGeneratedKeys();
        try {
            ArrayList<Object> list = new ArrayList<Object>();
            if (rs != null) {
                while (rs.next()) {
                    list.add(rs.getObject(1));
                }
            }
            this.selectReturning(((DefaultExecuteContext)ctx).originalConfiguration(), ctx.configuration(), list.toArray());
            int n = result;
            return n;
        }
        finally {
            JDBCUtils.safeClose(rs);
        }
    }

    private final void executeReturningQuery(ExecuteContext ctx, ExecuteListener listener) throws SQLException {
        listener.executeStart(ctx);
        ctx.resultSet(ctx.statement().executeQuery());
        listener.executeEnd(ctx);
    }

    private final void selectReturning(Configuration originalConfiguration, Configuration derivedConfiguration, Object ... values) {
        if (values != null && values.length > 0) {
            Field<?> returnIdentity = this.returnedIdentity();
            if (returnIdentity != null) {
                DataType type = returnIdentity.getDataType();
                Object[] ids = Tools.map(values, v -> type.convert(v), Object[]::new);
                if (this.returningResolvedAsterisks.size() == 1 && new FieldsImpl(this.returningResolvedAsterisks).field(returnIdentity) != null) {
                    AbstractRow<?> fields = Tools.row0(this.returningResolvedAsterisks.toArray(Tools.EMPTY_FIELD));
                    for (Object id : ids) {
                        this.getResult().add(Tools.newRecord(true, originalConfiguration, AbstractRecord.class, fields).operate(record -> {
                            record.values[0] = id;
                            record.originals[0] = id;
                            return record;
                        }));
                    }
                } else {
                    this.returnedResult = derivedConfiguration.dsl().select(this.returning).from((TableLike<?>)this.table).where(StringUtils.defaultIfNull(this.table.field(returnIdentity), returnIdentity).in(ids)).fetch();
                    this.returnedResult.attach(originalConfiguration);
                }
            }
        } else {
            this.logOnEmptyReturned(derivedConfiguration.dsl());
        }
    }

    private final Field<?> returnedIdentity() {
        return this.table.getIdentity() != null ? this.table.getIdentity().getField() : Tools.findAny(this.returningResolvedAsterisks, f -> f.getDataType().identity());
    }

    public final Field<?>[] getFields(ThrowingSupplier<? extends ResultSetMetaData, SQLException> rs) throws SQLException {
        return this.returningResolvedAsterisks.toArray(Tools.EMPTY_FIELD);
    }

    public final Class<? extends Record> getRecordType() {
        return Tools.recordType(this.returningResolvedAsterisks.size());
    }
}

