/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Catalog;
import com.oheers.fish.libs.jooq.Configuration;
import com.oheers.fish.libs.jooq.DDLExportConfiguration;
import com.oheers.fish.libs.jooq.Domain;
import com.oheers.fish.libs.jooq.ForeignKey;
import com.oheers.fish.libs.jooq.Index;
import com.oheers.fish.libs.jooq.Meta;
import com.oheers.fish.libs.jooq.MigrationConfiguration;
import com.oheers.fish.libs.jooq.Name;
import com.oheers.fish.libs.jooq.Named;
import com.oheers.fish.libs.jooq.Queries;
import com.oheers.fish.libs.jooq.Query;
import com.oheers.fish.libs.jooq.Record;
import com.oheers.fish.libs.jooq.Schema;
import com.oheers.fish.libs.jooq.Sequence;
import com.oheers.fish.libs.jooq.Table;
import com.oheers.fish.libs.jooq.TableField;
import com.oheers.fish.libs.jooq.UniqueKey;
import com.oheers.fish.libs.jooq.impl.AbstractScope;
import com.oheers.fish.libs.jooq.impl.DDL;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.Diff;
import com.oheers.fish.libs.jooq.impl.FilteredMeta;
import com.oheers.fish.libs.jooq.impl.InformationSchemaExport;
import com.oheers.fish.libs.jooq.impl.Internal;
import com.oheers.fish.libs.jooq.impl.Snapshot;
import com.oheers.fish.libs.jooq.impl.Tools;
import com.oheers.fish.libs.jooq.util.xml.jaxb.InformationSchema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

abstract class AbstractMeta
extends AbstractScope
implements Meta,
Serializable {
    private Map<Name, Catalog> cachedCatalogs;
    private Cached<Schema> cachedSchemas;
    private Cached<Table<?>> cachedTables;
    private Cached<Domain<?>> cachedDomains;
    private Cached<Sequence<?>> cachedSequences;
    private Cached<UniqueKey<?>> cachedPrimaryKeys;
    private Cached<UniqueKey<?>> cachedUniqueKeys;
    private Cached<ForeignKey<?, ?>> cachedForeignKeys;
    private Cached<Index> cachedIndexes;
    final Predicate<? super Catalog> catalogFilter;
    final Predicate<? super Schema> schemaFilter;

    AbstractMeta(Configuration configuration) {
        this(configuration, null, null);
    }

    AbstractMeta(Configuration configuration, Predicate<? super Catalog> catalogFilter, Predicate<? super Schema> schemaFilter) {
        super(configuration);
        this.catalogFilter = catalogFilter;
        this.schemaFilter = schemaFilter;
    }

    abstract AbstractMeta filtered0(Predicate<? super Catalog> var1, Predicate<? super Schema> var2);

    @Override
    public final Catalog getCatalog(String name) {
        return this.getCatalog(DSL.name(name));
    }

    @Override
    public final Catalog getCatalog(Name name) {
        return this.getCachedCatalogs().get(name);
    }

    @Override
    public final List<Catalog> getCatalogs() {
        return Collections.unmodifiableList(new ArrayList<Catalog>(this.getCachedCatalogs().values()));
    }

    private final Map<Name, Catalog> getCachedCatalogs() {
        Map<Name, Catalog> c = this.cachedCatalogs;
        if (c == null) {
            c = new LinkedHashMap<Name, Catalog>();
            for (Catalog catalog : this.getCatalogs0()) {
                c.put(catalog.getQualifiedName(), catalog);
            }
        }
        if (this.caching()) {
            this.cachedCatalogs = c;
        }
        return c;
    }

    abstract List<Catalog> getCatalogs0();

    @Override
    public final List<Schema> getSchemas(String name) {
        return this.getSchemas(DSL.name(name));
    }

    @Override
    public final List<Schema> getSchemas(Name name) {
        return this.getCachedSchemas().get(name);
    }

    @Override
    public final List<Schema> getSchemas() {
        return Collections.unmodifiableList(new ArrayList<Schema>(this.getCachedSchemas().qualified().values()));
    }

    private final Cached<Schema> getCachedSchemas() {
        Cached<Schema> s = this.cachedSchemas;
        if (s == null) {
            s = new Cached();
            s.init(this.schemaFilter != null ? () -> Tools.filter(this.getSchemas0().iterator(), this.schemaFilter) : () -> this.getSchemas0().iterator());
        }
        if (this.caching()) {
            this.cachedSchemas = s;
        }
        return s;
    }

    List<Schema> getSchemas0() {
        return Tools.flatMap(this.getCatalogs(), c -> c.getSchemas());
    }

    @Override
    public final List<Table<?>> getTables(String name) {
        return this.getTables(DSL.name(name));
    }

    @Override
    public final List<Table<?>> getTables(Name name) {
        return this.getCachedTables().get(name);
    }

    @Override
    public final List<Table<?>> getTables() {
        return Collections.unmodifiableList(new ArrayList(this.getCachedTables().qualified().values()));
    }

    private final Cached<Table<?>> getCachedTables() {
        Cached<Table<Object>> t = this.cachedTables;
        if (t == null) {
            t = new Cached();
            t.init(() -> this.getTables0().iterator());
        }
        if (this.caching()) {
            this.cachedTables = t;
        }
        return t;
    }

    List<Table<?>> getTables0() {
        return Tools.flatMap(this.getSchemas(), s -> s.getTables());
    }

    @Override
    public final List<Domain<?>> getDomains(String name) {
        return this.getDomains(DSL.name(name));
    }

    @Override
    public final List<Domain<?>> getDomains(Name name) {
        return this.getCachedDomains().get(name);
    }

    @Override
    public final List<Domain<?>> getDomains() {
        this.getCachedDomains();
        return Collections.unmodifiableList(new ArrayList(this.getCachedDomains().qualified().values()));
    }

    private final Cached<Domain<?>> getCachedDomains() {
        Cached<Domain<Object>> d = this.cachedDomains;
        if (d == null) {
            d = new Cached();
            d.init(() -> this.getDomains0().iterator());
        }
        if (this.caching()) {
            this.cachedDomains = d;
        }
        return d;
    }

    List<Domain<?>> getDomains0() {
        return Tools.flatMap(this.getSchemas(), s -> s.getDomains());
    }

    @Override
    public final List<Sequence<?>> getSequences(String name) {
        return this.getSequences(DSL.name(name));
    }

    @Override
    public final List<Sequence<?>> getSequences(Name name) {
        return this.getCachedSequences().get(name);
    }

    @Override
    public final List<Sequence<?>> getSequences() {
        return Collections.unmodifiableList(new ArrayList(this.getCachedSequences().qualified().values()));
    }

    private final Cached<Sequence<?>> getCachedSequences() {
        Cached<Sequence<Object>> s = this.cachedSequences;
        if (s == null) {
            s = new Cached();
            s.init(() -> this.getSequences0().iterator());
        }
        if (this.caching()) {
            this.cachedSequences = s;
        }
        return s;
    }

    final List<Sequence<?>> getSequences0() {
        return Tools.flatMap(this.getSchemas(), s -> s.getSequences());
    }

    @Override
    public final List<UniqueKey<?>> getPrimaryKeys(String name) {
        return this.getPrimaryKeys(DSL.name(name));
    }

    @Override
    public final List<UniqueKey<?>> getPrimaryKeys(Name name) {
        return this.getCachedPrimaryKeys().get(name);
    }

    @Override
    public final List<UniqueKey<?>> getPrimaryKeys() {
        return Collections.unmodifiableList(new ArrayList(this.getCachedPrimaryKeys().qualified().values()));
    }

    private final Cached<UniqueKey<?>> getCachedPrimaryKeys() {
        Cached<UniqueKey<Object>> k = this.cachedPrimaryKeys;
        if (k == null) {
            k = new Cached();
            k.init(() -> this.getPrimaryKeys0().iterator());
        }
        if (this.caching()) {
            this.cachedPrimaryKeys = k;
        }
        return k;
    }

    List<UniqueKey<?>> getPrimaryKeys0() {
        ArrayList result = new ArrayList();
        for (Table<?> table : this.getTables()) {
            if (table.getPrimaryKey() == null) continue;
            result.add(table.getPrimaryKey());
        }
        return result;
    }

    @Override
    public final List<UniqueKey<?>> getUniqueKeys(String name) {
        return this.getUniqueKeys(DSL.name(name));
    }

    @Override
    public final List<UniqueKey<?>> getUniqueKeys(Name name) {
        return this.getCachedUniqueKeys().get(name);
    }

    @Override
    public final List<UniqueKey<?>> getUniqueKeys() {
        return Collections.unmodifiableList(new ArrayList(this.getCachedUniqueKeys().qualified().values()));
    }

    private final Cached<UniqueKey<?>> getCachedUniqueKeys() {
        Cached<UniqueKey<Object>> k = this.cachedUniqueKeys;
        if (k == null) {
            k = new Cached();
            k.init(() -> this.getUniqueKeys0().iterator());
        }
        if (this.caching()) {
            this.cachedUniqueKeys = k;
        }
        return k;
    }

    List<UniqueKey<?>> getUniqueKeys0() {
        return Tools.flatMap(this.getTables(), t -> t.getUniqueKeys());
    }

    @Override
    public final List<ForeignKey<?, ?>> getForeignKeys(String name) {
        return this.getForeignKeys(DSL.name(name));
    }

    @Override
    public final List<ForeignKey<?, ?>> getForeignKeys(Name name) {
        return this.getCachedForeignKeys().get(name);
    }

    @Override
    public final List<ForeignKey<?, ?>> getForeignKeys() {
        return Collections.unmodifiableList(new ArrayList(this.getCachedForeignKeys().qualified().values()));
    }

    private final Cached<ForeignKey<?, ?>> getCachedForeignKeys() {
        Cached<ForeignKey<Object, Object>> k = this.cachedForeignKeys;
        if (k == null) {
            k = new Cached();
            k.init(() -> this.getForeignKeys0().iterator());
        }
        if (this.caching()) {
            this.cachedForeignKeys = k;
        }
        return k;
    }

    List<ForeignKey<?, ?>> getForeignKeys0() {
        return Tools.flatMap(this.getTables(), t -> t.getReferences());
    }

    @Override
    public final List<Index> getIndexes(String name) {
        return this.getIndexes(DSL.name(name));
    }

    @Override
    public final List<Index> getIndexes(Name name) {
        return this.getCachedIndexes().get(name);
    }

    @Override
    public final List<Index> getIndexes() {
        return Collections.unmodifiableList(new ArrayList<Index>(this.getCachedIndexes().qualified().values()));
    }

    private final Cached<Index> getCachedIndexes() {
        Cached<Index> i = this.cachedIndexes;
        if (i == null) {
            i = new Cached();
            i.init(() -> this.getIndexes0().iterator());
        }
        if (this.caching()) {
            this.cachedIndexes = i;
        }
        return i;
    }

    List<Index> getIndexes0() {
        return Tools.flatMap(this.getTables(), t -> t.getIndexes());
    }

    private boolean caching() {
        return true;
    }

    @Override
    public Meta filterCatalogs(Predicate<? super Catalog> filter) {
        return new FilteredMeta(this, filter, null, null, null, null, null, null, null, null);
    }

    @Override
    public Meta filterSchemas(Predicate<? super Schema> filter) {
        return new FilteredMeta(this, null, filter, null, null, null, null, null, null, null);
    }

    @Override
    public Meta filterTables(Predicate<? super Table<?>> filter) {
        return new FilteredMeta(this, null, null, filter, null, null, null, null, null, null);
    }

    @Override
    public Meta filterDomains(Predicate<? super Domain<?>> filter) {
        return new FilteredMeta(this, null, null, null, filter, null, null, null, null, null);
    }

    @Override
    public Meta filterSequences(Predicate<? super Sequence<?>> filter) {
        return new FilteredMeta(this, null, null, null, null, filter, null, null, null, null);
    }

    @Override
    public Meta filterPrimaryKeys(Predicate<? super UniqueKey<?>> filter) {
        return new FilteredMeta(this, null, null, null, null, null, filter, null, null, null);
    }

    @Override
    public Meta filterUniqueKeys(Predicate<? super UniqueKey<?>> filter) {
        return new FilteredMeta(this, null, null, null, null, null, null, filter, null, null);
    }

    @Override
    public Meta filterForeignKeys(Predicate<? super ForeignKey<?, ?>> filter) {
        return new FilteredMeta(this, null, null, null, null, null, null, null, filter, null);
    }

    @Override
    public Meta filterIndexes(Predicate<? super Index> filter) {
        return new FilteredMeta(this, null, null, null, null, null, null, null, null, filter);
    }

    @Override
    public final Meta snapshot() {
        return new Snapshot(this);
    }

    @Override
    public final Queries ddl() {
        return this.ddl(new DDLExportConfiguration());
    }

    @Override
    public Queries ddl(DDLExportConfiguration exportConfiguration) {
        return new DDL(this.dsl(), exportConfiguration).queries(this);
    }

    @Override
    public final Meta apply(String migration) {
        return this.apply(this.dsl().parser().parse(migration));
    }

    @Override
    public final Meta apply(Query ... migration) {
        return this.apply(this.dsl().queries(migration));
    }

    @Override
    public final Meta apply(Collection<? extends Query> migration) {
        return this.apply(this.dsl().queries(migration));
    }

    @Override
    public final Meta apply(Queries migration) {
        return this.dsl().meta(this.ddl().concat(migration).queries());
    }

    @Override
    public final Queries migrateTo(Meta other) {
        return this.migrateTo(other, new MigrationConfiguration());
    }

    @Override
    public final Queries migrateTo(Meta other, MigrationConfiguration c) {
        return new Diff(this.configuration(), c, this, other).queries();
    }

    @Override
    public InformationSchema informationSchema() {
        return InformationSchemaExport.exportCatalogs(this.configuration(), this.getCatalogs());
    }

    final Table<?> lookupTable(Table<?> table) {
        Catalog c = table.getCatalog();
        Schema s = table.getSchema();
        Catalog catalog = this.getCatalog(c == null ? "" : c.getName());
        if (catalog == null) {
            return null;
        }
        Schema schema = catalog.getSchema(s == null ? "" : s.getName());
        if (schema == null) {
            return null;
        }
        return schema.getTable(table.getName());
    }

    final <R extends Record> UniqueKey<R> lookupKey(Table<R> in, UniqueKey<?> uk) {
        HashSet ukFields = new HashSet(uk.getFields());
        return Tools.findAny(in.getKeys(), k -> ukFields.equals(new HashSet(k.getFields())));
    }

    final UniqueKey<?> lookupUniqueKey(ForeignKey<?, ?> fk) {
        Table<?> table = this.lookupTable(fk.getKey().getTable());
        if (table == null) {
            return null;
        }
        return this.lookupKey(table, fk.getKey());
    }

    static final <R extends Record> ForeignKey<R, ?> copyFK(Table<R> fkTable, UniqueKey<?> uk, ForeignKey<R, ?> oldFk) {
        Table ukTable = uk.getTable();
        return Internal.createForeignKey(fkTable, oldFk.getQualifiedName(), Tools.map(oldFk.getFieldsArray(), f -> (TableField)fkTable.field(f), TableField[]::new), uk, Tools.map(oldFk.getKeyFieldsArray(), f -> (TableField)ukTable.field(f), TableField[]::new), oldFk.enforced());
    }

    public int hashCode() {
        return this.ddl().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Meta) {
            Meta m = (Meta)obj;
            return this.ddl().equals(m.ddl());
        }
        return false;
    }

    public String toString() {
        return this.ddl().toString();
    }

    private record Cached<N extends Named>(Map<Name, N> qualified, Map<Name, List<N>> unqualified) {
        Cached() {
            this(new LinkedHashMap(), new LinkedHashMap<Name, List<N>>());
        }

        final void init(Iterable<N> i) {
            if (this.qualified().isEmpty()) {
                for (Named object : i) {
                    Name q = object.getQualifiedName();
                    Name u = object.getUnqualifiedName();
                    this.qualified().put(q, object);
                    this.unqualified().computeIfAbsent(u, n -> new ArrayList()).add(object);
                }
            }
        }

        final List<N> get(Name name) {
            Named object = (Named)this.qualified().get(name);
            if (object != null) {
                return Collections.singletonList(object);
            }
            List<N> list = this.unqualified().get(name);
            if (list == null) {
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(list);
        }
    }
}

