/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.Function2;
import com.oheers.fish.libs.jooq.impl.AbstractCondition;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.Names;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.SQLDataType;
import com.oheers.fish.libs.jooq.impl.Tools;
import java.util.Objects;

final class EndsWith<T>
extends AbstractCondition
implements QOM.EndsWith<T> {
    final Field<T> string;
    final Field<T> suffix;

    EndsWith(Field<T> string, Field<T> suffix) {
        this.string = Tools.nullableIf(false, Tools.nullSafe(string, suffix.getDataType()));
        this.suffix = Tools.nullableIf(false, Tools.nullSafe(suffix, string.getDataType()));
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        switch (ctx.family()) {
            case DUCKDB: {
                return true;
            }
        }
        return false;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case DUCKDB: {
                ctx.visit(DSL.function(Names.N_SUFFIX, SQLDataType.BOOLEAN, this.string, this.suffix));
                break;
            }
            default: {
                ctx.visit(this.string.like(DSL.concat(DSL.inline("%"), Tools.escapeForLike(this.suffix, ctx.configuration())), '!'));
            }
        }
    }

    @Override
    public final Field<T> $arg1() {
        return this.string;
    }

    @Override
    public final Field<T> $arg2() {
        return this.suffix;
    }

    @Override
    public final QOM.EndsWith<T> $arg1(Field<T> newValue) {
        return this.$constructor().apply(newValue, (Field<T>)this.$arg2());
    }

    @Override
    public final QOM.EndsWith<T> $arg2(Field<T> newValue) {
        return this.$constructor().apply((Field<T>)this.$arg1(), newValue);
    }

    @Override
    public final Function2<? super Field<T>, ? super Field<T>, ? extends QOM.EndsWith<T>> $constructor() {
        return (a1, a2) -> new EndsWith(a1, a2);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.EndsWith) {
            QOM.EndsWith o = (QOM.EndsWith)that;
            return Objects.equals(this.$string(), o.$string()) && Objects.equals(this.$suffix(), o.$suffix());
        }
        return super.equals(that);
    }
}

