/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.GroupField;
import com.oheers.fish.libs.jooq.QueryPart;
import com.oheers.fish.libs.jooq.SQLDialect;
import com.oheers.fish.libs.jooq.Table;
import com.oheers.fish.libs.jooq.UniqueKey;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.NoField;
import com.oheers.fish.libs.jooq.impl.QueryPartList;
import com.oheers.fish.libs.jooq.impl.QueryPartListView;
import java.util.Set;

final class GroupFieldList
extends QueryPartList<GroupField> {
    static final Set<SQLDialect> NO_SUPPORT_GROUP_BY_TABLE = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.DUCKDB, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES, SQLDialect.SQLITE, SQLDialect.TRINO, SQLDialect.YUGABYTEDB);
    static final Set<SQLDialect> NO_SUPPORT_GROUP_FUNCTIONAL_DEP = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.DUCKDB, SQLDialect.FIREBIRD, SQLDialect.TRINO);

    GroupFieldList() {
    }

    GroupFieldList(Iterable<? extends GroupField> wrappedList) {
        super(wrappedList);
    }

    GroupFieldList(GroupField[] wrappedList) {
        super((QueryPart[])wrappedList);
    }

    @Override
    final boolean canAdd(GroupField e) {
        return super.canAdd(e) && !(e instanceof NoField);
    }

    @Override
    public final boolean rendersContent(Context<?> ctx) {
        return true;
    }

    @Override
    protected final void toSQLEmptyList(Context<?> ctx) {
        ctx.visit(DSL.emptyGroupingSet());
    }

    @Override
    protected final void acceptElement(Context<?> ctx, GroupField part) {
        if (part instanceof Table) {
            Table t = (Table)part;
            if (NO_SUPPORT_GROUP_BY_TABLE.contains((Object)ctx.dialect())) {
                QueryPart[] f = this.fields(ctx, t);
                if (f.length > 1) {
                    ctx.visit(QueryPartListView.wrap((QueryPart[])f));
                } else if (f.length == 1) {
                    ctx.visit((Field<?>)f[0]);
                } else {
                    super.acceptElement(ctx, part);
                }
            } else {
                super.acceptElement(ctx, part);
            }
        } else {
            super.acceptElement(ctx, part);
        }
    }

    private final Field<?>[] fields(Context<?> ctx, Table<?> t) {
        UniqueKey<?> pk = t.getPrimaryKey();
        if (pk == null || NO_SUPPORT_GROUP_FUNCTIONAL_DEP.contains((Object)ctx.dialect())) {
            return t.fields();
        }
        return t.fields(pk.getFieldsArray());
    }
}

