/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.Function3;
import com.oheers.fish.libs.jooq.impl.AbstractField;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.Internal;
import com.oheers.fish.libs.jooq.impl.Keywords;
import com.oheers.fish.libs.jooq.impl.Names;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.SQLDataType;
import com.oheers.fish.libs.jooq.impl.Tools;
import java.util.Objects;

final class Position
extends AbstractField<Integer>
implements QOM.Position {
    final Field<String> in;
    final Field<String> search;
    final Field<? extends Number> startIndex;

    Position(Field<String> in, Field<String> search) {
        super(Names.N_POSITION, Tools.allNotNull(SQLDataType.INTEGER, in, search));
        this.in = Tools.nullSafeNotNull(in, SQLDataType.VARCHAR);
        this.search = Tools.nullSafeNotNull(search, SQLDataType.VARCHAR);
        this.startIndex = null;
    }

    Position(Field<String> in, Field<String> search, Field<? extends Number> startIndex) {
        super(Names.N_POSITION, Tools.allNotNull(SQLDataType.INTEGER, in, search, startIndex));
        this.in = Tools.nullSafeNotNull(in, SQLDataType.VARCHAR);
        this.search = Tools.nullSafeNotNull(search, SQLDataType.VARCHAR);
        this.startIndex = Tools.nullSafeNotNull(startIndex, SQLDataType.INTEGER);
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.startIndex != null) {
            switch (ctx.family()) {
                case DERBY: 
                case H2: {
                    ctx.visit(Names.N_LOCATE).sql('(').visit(this.search).sql(", ").visit(this.in).sql(", ").visit(this.startIndex).sql(')');
                    break;
                }
                default: {
                    ctx.visit(DSL.case_(DSL.position(DSL.substring(this.in, this.startIndex), this.search)).when((Field<Integer>)DSL.inline(0), DSL.inline(0)).else_(Internal.iadd(DSL.position(DSL.substring(this.in, this.startIndex), this.search), Internal.isub(this.startIndex, DSL.one()))));
                    break;
                }
            }
        } else {
            switch (ctx.family()) {
                case DERBY: {
                    ctx.visit(Names.N_LOCATE).sql('(').visit(this.search).sql(", ").visit(this.in).sql(')');
                    break;
                }
                case SQLITE: {
                    ctx.visit(Names.N_INSTR).sql('(').visit(this.in).sql(", ").visit(this.search).sql(')');
                    break;
                }
                default: {
                    ctx.visit(Names.N_POSITION).sql('(').visit(this.search).sql(' ').visit(Keywords.K_IN).sql(' ').visit(this.in).sql(')');
                }
            }
        }
    }

    @Override
    public final Field<String> $arg1() {
        return this.in;
    }

    @Override
    public final Field<String> $arg2() {
        return this.search;
    }

    @Override
    public final Field<? extends Number> $arg3() {
        return this.startIndex;
    }

    @Override
    public final QOM.Position $arg1(Field<String> newValue) {
        return this.$constructor().apply((Field<String>)newValue, (Field<String>)this.$arg2(), (Field<? extends Number>)this.$arg3());
    }

    @Override
    public final QOM.Position $arg2(Field<String> newValue) {
        return this.$constructor().apply((Field<String>)this.$arg1(), (Field<String>)newValue, (Field<? extends Number>)this.$arg3());
    }

    @Override
    public final QOM.Position $arg3(Field<? extends Number> newValue) {
        return this.$constructor().apply((Field<String>)this.$arg1(), (Field<String>)this.$arg2(), (Field<? extends Number>)newValue);
    }

    @Override
    public final Function3<? super Field<String>, ? super Field<String>, ? super Field<? extends Number>, ? extends QOM.Position> $constructor() {
        return (a1, a2, a3) -> new Position((Field<String>)a1, (Field<String>)a2, (Field<? extends Number>)a3);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.Position) {
            QOM.Position o = (QOM.Position)that;
            return Objects.equals(this.$in(), o.$in()) && Objects.equals(this.$search(), o.$search()) && Objects.equals(this.$startIndex(), o.$startIndex());
        }
        return super.equals(that);
    }
}

