/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.QueryPart;
import com.oheers.fish.libs.jooq.SQLDialect;
import com.oheers.fish.libs.jooq.Table;
import com.oheers.fish.libs.jooq.impl.Dual;
import com.oheers.fish.libs.jooq.impl.QueryPartList;
import com.oheers.fish.libs.jooq.impl.Tools;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

final class TableList
extends QueryPartList<Table<?>> {
    private static final Set<SQLDialect> UNQUALIFY_FIELDS = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.H2, SQLDialect.HSQLDB);

    TableList() {
    }

    TableList(List<? extends Table<?>> wrappedList) {
        super(wrappedList);
    }

    @SafeVarargs
    TableList(Table<?> ... wrappedList) {
        super((QueryPart[])wrappedList);
    }

    @Override
    public final boolean rendersContent(Context<?> ctx) {
        return true;
    }

    @Override
    protected void acceptElement(Context<?> ctx, Table<?> part) {
        Tools.visitAutoAliased(ctx, part, Context::declareTables, (c, t) -> super.acceptElement((Context<?>)c, t));
    }

    @Override
    protected void toSQLEmptyList(Context<?> ctx) {
        ctx.visit(new Dual());
    }

    @Override
    public final boolean declaresTables() {
        return true;
    }

    final List<Field<?>> fields() {
        return Tools.flatMap(this, t -> Arrays.asList(t.fieldsRow().fields()));
    }

    final void toSQLFields(Context<?> ctx) {
        ctx.qualify(!UNQUALIFY_FIELDS.contains((Object)ctx.dialect()) && ctx.qualify(), c -> {
            String sep = "";
            for (Table table : this) {
                for (Field<?> field : table.fieldsRow().fields()) {
                    ctx.sql(sep);
                    ctx.visit(field);
                    sep = ", ";
                }
            }
        });
    }
}

