/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.QueryPart;
import com.oheers.fish.libs.jooq.TableLike;
import com.oheers.fish.libs.jooq.XML;
import com.oheers.fish.libs.jooq.XMLQueryPassingStep;
import com.oheers.fish.libs.jooq.impl.AbstractField;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.Names;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.SQLDataType;
import com.oheers.fish.libs.jooq.impl.Tools;
import com.oheers.fish.libs.jooq.impl.XMLTable;

final class XMLQuery
extends AbstractField<XML>
implements XMLQueryPassingStep,
QOM.XMLQuery {
    private final Field<String> xpath;
    private final Field<XML> passing;
    private final QOM.XMLPassingMechanism passingMechanism;

    XMLQuery(Field<String> xpath) {
        this(xpath, null, null);
    }

    private XMLQuery(Field<String> xpath, Field<XML> passing, QOM.XMLPassingMechanism passingMechanism) {
        super(Names.N_XMLQUERY, SQLDataType.XML);
        this.xpath = xpath;
        this.passing = passing;
        this.passingMechanism = passingMechanism;
    }

    @Override
    public final Field<XML> passing(XML xml) {
        return this.passing(Tools.field(xml));
    }

    @Override
    public final Field<XML> passing(Field<XML> xml) {
        return new XMLQuery(this.xpath, xml, null);
    }

    @Override
    public final Field<XML> passingByRef(XML xml) {
        return this.passingByRef(Tools.field(xml));
    }

    @Override
    public final Field<XML> passingByRef(Field<XML> xml) {
        return new XMLQuery(this.xpath, xml, QOM.XMLPassingMechanism.BY_REF);
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case POSTGRES: {
                Field<XML> x = DSL.field(DSL.name("x"), SQLDataType.XML);
                ctx.sql('(').visit(DSL.select(DSL.xmlagg(x)).from((TableLike<?>)DSL.unnest(DSL.field("xpath({0}, {1})", SQLDataType.XML.getArrayDataType(), new QueryPart[]{this.xpath, this.passing})).as("t", x.getName()))).sql(')');
                break;
            }
            default: {
                ctx.visit(Names.N_XMLQUERY).sqlIndentStart('(');
                XMLTable.acceptXPath(ctx, this.xpath);
                XMLTable.acceptPassing(ctx, this.passing, this.passingMechanism);
                ctx.sqlIndentEnd(')');
            }
        }
    }

    @Override
    public final Field<String> $xpath() {
        return this.xpath;
    }

    @Override
    public final Field<XML> $passing() {
        return this.passing;
    }

    @Override
    public final QOM.XMLPassingMechanism $passingMechanism() {
        return this.passingMechanism;
    }
}

