/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.addons.internal.requirement;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.api.requirement.RequirementContext;
import com.oheers.fish.api.requirement.RequirementType;
import java.util.List;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class InGameTimeRequirementType
extends RequirementType {
    @Override
    public boolean checkRequirement(@NotNull RequirementContext context, @NotNull List<String> values) {
        World world = context.getWorld();
        if (world == null) {
            String configLocation = context.getConfigPath();
            if (configLocation == null) {
                configLocation = "N/A";
            }
            EvenMoreFish.getInstance().getLogger().severe("Could not get world for " + configLocation + ", returning false by default. The player may not have been given a fish if you see this message multiple times.");
            return false;
        }
        for (String value : values) {
            int maxTime;
            int minTime;
            String[] split = value.split("-");
            try {
                minTime = Integer.parseInt(split[0]);
                maxTime = Integer.parseInt(split[1]);
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException exception) {
                EvenMoreFish.getInstance().getLogger().severe(value + " is not a valid ingame time format. Using the defaults.");
                minTime = 0;
                maxTime = 24000;
            }
            if (world.getTime() > (long)maxTime || world.getTime() < (long)minTime) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return "INGAME-TIME";
    }

    @Override
    @NotNull
    public String getAuthor() {
        return "Oheers";
    }

    @Override
    @NotNull
    public Plugin getPlugin() {
        return EvenMoreFish.getInstance();
    }
}

