/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.api.addons;

import com.oheers.fish.api.plugin.EMFPlugin;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ItemAddon
implements Listener {
    private static final Map<String, ItemAddon> loaded = new HashMap<String, ItemAddon>();

    public static Map<String, ItemAddon> getLoadedAddons() {
        return Map.copyOf(loaded);
    }

    public static void unregisterAll() {
        loaded.clear();
    }

    @Nullable
    public static ItemAddon get(@NotNull String prefix) {
        return loaded.get(prefix);
    }

    @Nullable
    public static ItemStack getItem(@NotNull String prefix, @NotNull String id) {
        ItemAddon addon = loaded.get(prefix);
        if (addon == null) {
            return null;
        }
        return addon.getItemStack(id);
    }

    public abstract ItemStack getItemStack(String var1);

    public abstract String getPluginName();

    public abstract String getAuthor();

    public abstract String getIdentifier();

    public String getVersion() {
        return "0.0.0";
    }

    public boolean canLoad() {
        return this.getPluginName() == null || Bukkit.getPluginManager().isPluginEnabled(this.getPluginName());
    }

    public boolean register() {
        if (!this.canLoad()) {
            return false;
        }
        String id = this.getIdentifier();
        if (loaded.containsKey(id)) {
            return false;
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)EMFPlugin.getInstance());
        loaded.put(id, this);
        EMFPlugin.getInstance().debug("Loaded " + this.getIdentifier() + " ItemAddon.");
        return true;
    }

    public final String toString() {
        return String.format("ItemAddon[prefix: %s, author: %s]", this.getIdentifier(), this.getAuthor());
    }

    protected Logger getLogger() {
        return EMFPlugin.getInstance().getLogger();
    }
}

