/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.api.plugin;

import java.util.logging.Level;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EMFPlugin
extends JavaPlugin {
    private static EMFPlugin instance;

    protected EMFPlugin() {
        if (instance != null) {
            throw new UnsupportedOperationException("EMFPlugin has already been assigned!");
        }
        instance = this;
    }

    @NotNull
    public static EMFPlugin getInstance() {
        if (instance == null) {
            throw new RuntimeException("EMFPlugin not found. This should not happen!");
        }
        return instance;
    }

    public void debug(String message) {
        this.debug(Level.INFO, message);
    }

    public void debug(String message, Exception e) {
        this.debug(Level.INFO, message, e);
    }

    public void debug(Level level, String message) {
        if (this.isDebugSession()) {
            EMFPlugin.getInstance().getLogger().log(level, () -> "DEBUG %s".formatted(message));
        }
    }

    public void debug(Level level, String message, Exception e) {
        if (this.isDebugSession()) {
            EMFPlugin.getInstance().getLogger().log(level, "DEBUG %s".formatted(message), e);
        }
    }

    public abstract boolean isDebugSession();

    public abstract void reload(@Nullable CommandSender var1);
}

