/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.api.requirement;

import com.oheers.fish.api.plugin.EMFPlugin;
import com.oheers.fish.api.requirement.RequirementContext;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RequirementType {
    private static final Map<String, RequirementType> loadedTypes = new TreeMap<String, RequirementType>(String.CASE_INSENSITIVE_ORDER);

    public static Map<String, RequirementType> getLoadedTypes() {
        return Map.copyOf(loadedTypes);
    }

    public static void unregisterAll() {
        loadedTypes.clear();
    }

    @Nullable
    public static RequirementType get(@NotNull String identifier) {
        return loadedTypes.get(identifier);
    }

    public static boolean unregister(@NotNull String identifier) {
        if (!loadedTypes.containsKey(identifier)) {
            return false;
        }
        loadedTypes.remove(identifier);
        return true;
    }

    public abstract boolean checkRequirement(@NotNull RequirementContext var1, @NotNull List<String> var2);

    @NotNull
    public abstract String getIdentifier();

    @NotNull
    public abstract String getAuthor();

    @NotNull
    public abstract Plugin getPlugin();

    public boolean register() {
        if (loadedTypes.containsKey(this.getIdentifier())) {
            return false;
        }
        loadedTypes.put(this.getIdentifier(), this);
        EMFPlugin.getInstance().debug("Registered " + this.getIdentifier() + " RequirementType");
        return true;
    }

    public boolean unregister() {
        return RequirementType.unregister(this.getIdentifier());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RequirementType)) {
            return false;
        }
        RequirementType type = (RequirementType)obj;
        return this.getIdentifier().equals(type.getIdentifier());
    }

    public int hashCode() {
        return this.getIdentifier().hashCode();
    }
}

