/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.api.reward;

import com.oheers.fish.api.plugin.EMFPlugin;
import com.oheers.fish.api.reward.RewardType;
import java.util.Arrays;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Reward {
    @NotNull
    private final String key;
    @NotNull
    private final String value;
    private RewardType rewardType = null;
    private Vector fishVelocity;

    public Reward(@NotNull String identifier) {
        String[] split = identifier.split(":");
        if (split.length < 2) {
            EMFPlugin.getInstance().getLogger().warning(identifier + " is not formatted correctly. It won't be given as a reward");
            this.key = "";
            this.value = "";
        } else {
            this.key = split[0];
            this.value = String.join((CharSequence)":", Arrays.copyOfRange(split, 1, split.length));
        }
        RewardType rewardType = RewardType.get(this.key);
        if (rewardType != null) {
            this.rewardType = rewardType;
        }
    }

    public RewardType getRewardType() {
        return this.rewardType;
    }

    @NotNull
    public String getKey() {
        return this.key;
    }

    @NotNull
    public String getValue() {
        return this.value;
    }

    public void rewardPlayer(@NotNull Player player, Location hookLocation) {
        if (this.getRewardType() == null) {
            EMFPlugin.getInstance().getLogger().warning("No reward type found for key: " + this.getKey());
            return;
        }
        this.getRewardType().doReward(player, this.getKey(), this.getValue(), hookLocation);
    }

    public void setFishVelocity(@Nullable Vector fishVelocity) {
        this.fishVelocity = fishVelocity;
    }

    @Nullable
    public Vector getFishVelocity() {
        return this.fishVelocity;
    }
}

