/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.api.reward;

import com.oheers.fish.api.plugin.EMFPlugin;
import java.util.Map;
import java.util.TreeMap;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RewardType {
    private static final Map<String, RewardType> loadedTypes = new TreeMap<String, RewardType>(String.CASE_INSENSITIVE_ORDER);

    public static Map<String, RewardType> getLoadedTypes() {
        return Map.copyOf(loadedTypes);
    }

    public static void unregisterAll() {
        loadedTypes.clear();
    }

    @Nullable
    public static RewardType get(@NotNull String identifier) {
        return loadedTypes.get(identifier);
    }

    public static boolean unregister(@NotNull String identifier) {
        if (!loadedTypes.containsKey(identifier)) {
            return false;
        }
        loadedTypes.remove(identifier);
        return true;
    }

    public abstract void doReward(@NotNull Player var1, @NotNull String var2, @NotNull String var3, Location var4);

    @NotNull
    public abstract String getIdentifier();

    @NotNull
    public abstract String getAuthor();

    @NotNull
    public abstract Plugin getPlugin();

    public boolean register() {
        if (loadedTypes.containsKey(this.getIdentifier())) {
            return false;
        }
        loadedTypes.put(this.getIdentifier(), this);
        EMFPlugin.getInstance().debug("Registered " + this.getIdentifier() + " RewardType");
        return true;
    }

    public boolean unregister() {
        return RewardType.unregister(this.getIdentifier());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RewardType)) {
            return false;
        }
        RewardType type = (RewardType)obj;
        return this.getIdentifier().equals(type.getIdentifier());
    }

    public int hashCode() {
        return this.getIdentifier().hashCode();
    }
}

