/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.api.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestUtil {
    private static final Logger logger = LoggerFactory.getLogger(ManifestUtil.class.getName());
    private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";

    private ManifestUtil() {
        throw new UnsupportedOperationException();
    }

    public static String getAttributeFromManifest(String key, String defaultValue) {
        return ManifestUtil.getAttributeFromManifest(ManifestUtil.class.getClassLoader(), key, defaultValue);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getAttributeFromManifest(ClassLoader classLoader, String key, String defaultValue) {
        if (key == null) throw new IllegalArgumentException("Key cannot be null or empty");
        if (key.isEmpty()) {
            throw new IllegalArgumentException("Key cannot be null or empty");
        }
        try (InputStream inputStream = classLoader.getResourceAsStream(MANIFEST_PATH);){
            if (inputStream == null) return defaultValue;
            Manifest manifest = new Manifest(inputStream);
            String value = manifest.getMainAttributes().getValue(key);
            String string = value != null ? value : defaultValue;
            return string;
        }
        catch (IOException e) {
            logger.error("Error reading manifest file: {}", (Object)e.getMessage());
        }
        return defaultValue;
    }
}

