/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.api.utils.system;

import com.oheers.fish.api.utils.system.JavaSpecVersion;
import org.jetbrains.annotations.NotNull;

public class SystemUtils {
    public static final String JAVA_VERSION = System.getProperty("java.specification.version");

    private SystemUtils() {
        throw new UnsupportedOperationException();
    }

    public static boolean isJavaVersionAtLeast(@NotNull JavaSpecVersion required) {
        return SystemUtils.isJavaVersionAtLeast(JAVA_VERSION, required);
    }

    static boolean isJavaVersionAtLeast(@NotNull String currentVersion, @NotNull JavaSpecVersion required) {
        float current = SystemUtils.parseJavaVersion(currentVersion);
        return current >= required.getValue();
    }

    static float parseJavaVersion(@NotNull String version) {
        String[] parts = version.split("\\.");
        try {
            if (parts[0].equals("1")) {
                if (parts.length > 1 && !parts[1].isBlank()) {
                    return Float.parseFloat(parts[0] + "." + parts[1]);
                }
                return -1.0f;
            }
            if (parts.length == 1 && !parts[0].isBlank()) {
                return Float.parseFloat(parts[0]);
            }
            return -1.0f;
        }
        catch (NumberFormatException e) {
            return -1.0f;
        }
    }
}

