/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.baits;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.baits.BaitItemFactory;
import com.oheers.fish.baits.configs.BaitFileUpdates;
import com.oheers.fish.baits.manager.BaitNBTManager;
import com.oheers.fish.baits.model.ApplicationResult;
import com.oheers.fish.baits.model.BaitData;
import com.oheers.fish.config.ConfigBase;
import com.oheers.fish.config.MainConfig;
import com.oheers.fish.database.data.FishRarityKey;
import com.oheers.fish.exceptions.MaxBaitReachedException;
import com.oheers.fish.exceptions.MaxBaitsReachedException;
import com.oheers.fish.fishing.items.Fish;
import com.oheers.fish.fishing.items.FishManager;
import com.oheers.fish.fishing.items.Rarity;
import com.oheers.fish.items.ItemFactory;
import com.oheers.fish.libs.boostedyaml.block.implementation.Section;
import com.oheers.fish.messages.ConfigMessage;
import com.oheers.fish.messages.EMFSingleMessage;
import com.oheers.fish.messages.abstracted.EMFMessage;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaitHandler
extends ConfigBase {
    @NotNull
    private final String id;
    private BaitData baitData;
    private ItemFactory itemFactory;
    private static final double DEFAULT_BOOST_RATE = 1.0;
    private final Logger logger = EvenMoreFish.getInstance().getLogger();
    private final FishManager fishManager;
    private final MainConfig mainConfig;

    public BaitHandler(@NotNull File file, FishManager fishManager, MainConfig mainConfig) throws InvalidConfigurationException {
        super(file, (Plugin)EvenMoreFish.getInstance(), false);
        BaitFileUpdates.update(this);
        this.id = this.validateAndGetId();
        this.baitData = this.loadBaitData();
        this.fishManager = fishManager;
        this.mainConfig = mainConfig;
        this.itemFactory = new BaitItemFactory(this.baitData.id(), this.baitData.rarities(), this.baitData.fish(), this.getConfig()).createFactory();
    }

    private String validateAndGetId() throws InvalidConfigurationException {
        String baitId = this.getConfig().getString("id");
        if (baitId == null) {
            this.logger.warning("Rarity invalid: 'id' missing in " + this.getFileName());
            throw new InvalidConfigurationException("An ID has not been found in " + this.getFileName() + ". Please correct this.");
        }
        return baitId;
    }

    public ItemStack create(@NotNull OfflinePlayer player) {
        return this.itemFactory.createItem(player.getUniqueId());
    }

    private BaitData loadBaitData() {
        List<Rarity> rarities = this.resolveRarity();
        List<Fish> fish = this.resolveFish();
        return new BaitData(this.id, this.getConfig().getString("item.displayname", this.id), rarities, fish, this.getConfig().getBoolean("disabled", (Boolean)false), this.getConfig().getBoolean("infinite", (Boolean)false), this.getConfig().getInt("max-applications", (Integer)-1), this.getConfig().getInt("drop-quantity", (Integer)1), this.getConfig().getDouble("application-weight", (Double)100.0), this.getConfig().getDouble("catch-weight", (Double)100.0), this.getConfig().getBoolean("can-be-caught", (Boolean)true), this.getConfig().getBoolean("disable-use-alert", (Boolean)false));
    }

    @NotNull
    public List<Rarity> getRarities() {
        return this.baitData.rarities();
    }

    private List<Rarity> resolveRarity() {
        List<String> rarityStrings = this.getConfig().getStringList("rarities");
        return rarityStrings.stream().map(FishManager.getInstance()::getRarity).filter(Objects::nonNull).toList();
    }

    private List<Fish> resolveFish() {
        Section fishSection = this.getConfig().getSection("fish");
        if (fishSection == null) {
            EvenMoreFish.getInstance().debug("Fish section was null in bait. Returning empty list..");
            return Collections.emptyList();
        }
        return this.getConfig().getSection("fish").getRoutesAsStrings(false).stream().map(FishManager.getInstance()::getRarity).filter(Objects::nonNull).flatMap(rarity -> rarity.getFishList().stream()).filter(fish -> this.getConfig().getStringList("fish." + fish.getRarity().getId()).contains(fish.getName())).toList();
    }

    @NotNull
    private List<Fish> getFish() {
        return this.baitData.fish();
    }

    public Fish chooseFish(@NotNull Player player, @NotNull Location location) {
        Set<Rarity> boostedRarities = this.determineBoostedRarities();
        Rarity selectedRarity = this.selectRarityWithBoosts(player, boostedRarities);
        Fish selectedFish = this.selectFishFromRarity(selectedRarity, player, location);
        this.processBaitUsage(player, selectedRarity, selectedFish);
        return selectedFish;
    }

    @NotNull
    private Set<Rarity> determineBoostedRarities() {
        HashSet<Rarity> boosted = new HashSet<Rarity>(this.getRarities());
        this.getFish().stream().map(Fish::getRarity).forEach(boosted::add);
        return boosted;
    }

    private Rarity selectRarityWithBoosts(Player player, Set<Rarity> boostedRarities) {
        return this.fishManager.getRandomWeightedRarity(player, this.mainConfig.getBaitBoostRate(), boostedRarities, Set.copyOf(this.fishManager.getRarityMap().values()), null);
    }

    private Fish selectFishFromRarity(Rarity rarity, Player player, Location location) {
        List<Fish> eligibleFish = this.getEligibleFishForRarity(rarity);
        double boostRate = this.shouldApplyBoost(rarity) ? this.mainConfig.getBaitBoostRate() : 1.0;
        return this.fishManager.getFish(rarity, location, player, boostRate, eligibleFish, true, null, null);
    }

    @Nullable
    private List<Fish> getEligibleFishForRarity(Rarity rarity) {
        if (this.getFish().isEmpty()) {
            return null;
        }
        if (this.getFish().stream().anyMatch(f -> f.getRarity().equals(rarity))) {
            return this.getFish();
        }
        return rarity.getFishList();
    }

    private boolean shouldApplyBoost(Rarity rarity) {
        return this.getRarities().contains(rarity) || this.getFish().stream().anyMatch(f -> f.getRarity().equals(rarity));
    }

    private void processBaitUsage(Player player, Rarity rarity, Fish fish) {
        if (fish == null) {
            return;
        }
        fish.setWasBaited(true);
        fish.setFisherman(player.getUniqueId());
        if (this.shouldAlertUsage(rarity, fish)) {
            this.alertUsage(player);
        }
    }

    private boolean shouldAlertUsage(Rarity rarity, Fish fish) {
        return this.getRarities().contains(rarity) || !this.getFish().isEmpty() && this.getFish().contains(fish);
    }

    public void handleFish(@NotNull Player player, @NotNull Fish fish, @NotNull ItemStack fishingRod) {
        if (!fish.isWasBaited()) {
            EvenMoreFish.getInstance().debug("Fish: %s was not baited, ignoring..".formatted(FishRarityKey.of(fish)));
            return;
        }
        EvenMoreFish.getInstance().debug("Fish: %s was baited".formatted(FishRarityKey.of(fish)));
        fish.setFisherman(player.getUniqueId());
        if (!this.shouldConsumeBait(fish)) {
            return;
        }
        try {
            ApplicationResult result = BaitNBTManager.applyBaitedRodNBT(fishingRod, this, -1);
            if (result == null || result.getFishingRod() == null) {
                return;
            }
            fishingRod.setItemMeta(result.getFishingRod().getItemMeta());
            EvenMoreFish.getInstance().getMetricsManager().incrementBaitsUsed(1);
        }
        catch (MaxBaitReachedException | MaxBaitsReachedException e) {
            this.logger.log(Level.WARNING, e.getMessage());
            player.sendMessage(e.getConfigMessage().getMessage().getComponentMessage((OfflinePlayer)player));
        }
        catch (NullPointerException exception) {
            this.logger.log(Level.SEVERE, exception.getMessage(), exception);
        }
    }

    private boolean shouldConsumeBait(@NotNull Fish fish) {
        return this.getRarities().contains(fish.getRarity()) || this.getFish().contains(fish);
    }

    private void alertUsage(Player player) {
        if (this.baitData.disableUseAlert()) {
            return;
        }
        EMFMessage message = ConfigMessage.BAIT_USED.getMessage();
        message.setBait(this.format(this.getDisplayName()));
        message.send((Audience)player);
    }

    @NotNull
    public String getId() {
        return this.baitData.id();
    }

    @NotNull
    public EMFSingleMessage getFormat() {
        String format = this.getConfig().getString("format", "<yellow>{name}");
        return EMFSingleMessage.fromString(format);
    }

    @NotNull
    public EMFSingleMessage format(@NotNull String name) {
        EMFSingleMessage message = this.getFormat();
        message.setVariable("{name}", name);
        return message;
    }

    public String getDisplayName() {
        return this.baitData.displayName();
    }

    @Override
    public void reload(@NotNull File configFile) {
        super.reload(configFile);
        this.baitData = this.loadBaitData();
        this.itemFactory = new BaitItemFactory(this.baitData.id(), this.baitData.rarities(), this.baitData.fish(), this.getConfig()).createFactory();
    }

    @Override
    public void reload() {
        super.reload();
        this.baitData = this.loadBaitData();
        this.itemFactory = new BaitItemFactory(this.baitData.id(), this.baitData.rarities(), this.baitData.fish(), this.getConfig()).createFactory();
    }

    public BaitData getBaitData() {
        return this.baitData;
    }
}

