/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.commands;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.FishUtils;
import com.oheers.fish.api.addons.ItemAddon;
import com.oheers.fish.api.requirement.RequirementType;
import com.oheers.fish.api.reward.RewardType;
import com.oheers.fish.api.utils.ManifestUtil;
import com.oheers.fish.baits.BaitHandler;
import com.oheers.fish.baits.manager.BaitManager;
import com.oheers.fish.baits.manager.BaitNBTManager;
import com.oheers.fish.commands.AdminDatabaseCommand;
import com.oheers.fish.commands.HelpMessageBuilder;
import com.oheers.fish.commands.arguments.ArgumentHelper;
import com.oheers.fish.commands.arguments.BaitArgument;
import com.oheers.fish.commands.arguments.CompetitionTypeArgument;
import com.oheers.fish.commands.arguments.CustomRodArgument;
import com.oheers.fish.commands.arguments.FishArgument;
import com.oheers.fish.commands.arguments.RarityArgument;
import com.oheers.fish.competition.Competition;
import com.oheers.fish.competition.CompetitionType;
import com.oheers.fish.competition.configs.CompetitionFile;
import com.oheers.fish.config.ConfigBase;
import com.oheers.fish.database.Database;
import com.oheers.fish.database.DatabaseUtil;
import com.oheers.fish.fishing.items.Fish;
import com.oheers.fish.fishing.items.FishManager;
import com.oheers.fish.fishing.items.Rarity;
import com.oheers.fish.fishing.rods.CustomRod;
import com.oheers.fish.libs.boostedyaml.YamlDocument;
import com.oheers.fish.libs.commandapi.CommandAPICommand;
import com.oheers.fish.libs.commandapi.arguments.Argument;
import com.oheers.fish.libs.commandapi.arguments.EntitySelectorArgument;
import com.oheers.fish.libs.commandapi.arguments.IntegerArgument;
import com.oheers.fish.libs.commandapi.arguments.MultiLiteralArgument;
import com.oheers.fish.libs.commandapi.executors.ExecutorType;
import com.oheers.fish.messages.ConfigMessage;
import com.oheers.fish.messages.EMFSingleMessage;
import com.oheers.fish.messages.PrefixType;
import com.oheers.fish.messages.abstracted.EMFMessage;
import com.oheers.fish.utils.nbtapi.NBT;
import java.util.List;
import java.util.Objects;
import java.util.jar.Attributes;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentBuilder;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdminCommand {
    public static final HelpMessageBuilder HELP_MESSAGE = HelpMessageBuilder.create();
    private final CommandAPICommand command;

    public AdminCommand(@NotNull String name) {
        this.command = (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand(name).withPermission("emf.admin")).executes(info -> this.sendHelpMessage((CommandSender)info.sender()), new ExecutorType[0])).withSubcommands(new CommandAPICommand[]{this.getFish(), this.getList(), this.getCompetition(), this.getCustomRod(), this.getBait(), this.getClearBaits(), this.getReload(), this.getVersion(), this.getRewardTypes(), this.getMigrate(), this.getRawItem(), this.getHelp(), new AdminDatabaseCommand()});
    }

    public CommandAPICommand getCommand() {
        return this.command;
    }

    private void sendHelpMessage(@NotNull CommandSender sender) {
        HELP_MESSAGE.sendMessage(sender);
    }

    private CommandAPICommand getFish() {
        HELP_MESSAGE.addUsage("admin fish", ConfigMessage.HELP_ADMIN_FISH::getMessage);
        return (CommandAPICommand)((CommandAPICommand)new CommandAPICommand("fish").withArguments(new Argument[]{RarityArgument.create(), FishArgument.create(), (Argument)new IntegerArgument("amount", 1).setOptional(true), (Argument)new EntitySelectorArgument.ManyPlayers("targets").setOptional(true)})).executes((sender, arguments) -> {
            Fish initialFish = (Fish)arguments.getUnchecked("fish");
            if (initialFish == null) {
                return;
            }
            int amount = (Integer)arguments.getOptional("amount").orElse(1);
            List targets = (List)arguments.getOptional("targets").orElseGet(() -> {
                if (sender instanceof Player) {
                    Player player = (Player)sender;
                    return List.of(player);
                }
                return null;
            });
            if (targets == null) {
                ConfigMessage.ADMIN_CANT_BE_CONSOLE.getMessage().send((Audience)sender);
                return;
            }
            for (Player target : targets) {
                Fish fish = initialFish.createCopy();
                fish.init();
                if (fish.hasFishRewards()) {
                    fish.getFishRewards().forEach(reward -> reward.rewardPlayer(target, target.getLocation()));
                }
                fish.setFisherman(target.getUniqueId());
                ItemStack fishItem = fish.give();
                fishItem.setAmount(amount);
                FishUtils.giveItem(fishItem, target);
            }
            EMFMessage message = ConfigMessage.ADMIN_GIVE_PLAYER_FISH.getMessage();
            message.setVariable("{player}", this.getPlayersVariable(arguments.getRaw("targets"), targets));
            message.setFishCaught(initialFish.getName());
            message.send((Audience)sender);
        }, new ExecutorType[0]);
    }

    private CommandAPICommand getList() {
        return (CommandAPICommand)((CommandAPICommand)new CommandAPICommand("list").withArguments(new Argument[]{new MultiLiteralArgument("listTarget", "fish", "rarities", "requirementTypes", "rewardTypes", "itemAddons"), (Argument)RarityArgument.create().setOptional(true)})).executes((sender, args) -> {
            String listTarget;
            switch (listTarget = Objects.requireNonNull((String)args.getUnchecked("listTarget"))) {
                case "fish": {
                    Rarity rarity = (Rarity)args.getUnchecked("rarity");
                    if (rarity == null) {
                        ConfigMessage.RARITY_INVALID.getMessage().send((Audience)sender);
                        return;
                    }
                    TextComponent.Builder builder = Component.text();
                    builder.append(rarity.getDisplayName().getComponentMessage());
                    builder.append((Component)Component.space());
                    for (Fish fish : rarity.getOriginalFishList()) {
                        TextComponent.Builder fishBuilder = Component.text();
                        EMFSingleMessage message = EMFSingleMessage.fromString("<gray>[</gray>{fish}<gray>]</gray>");
                        message.setVariable("{fish}", fish.getDisplayName());
                        fishBuilder.append(message.getComponentMessage());
                        fishBuilder.hoverEvent((HoverEventSource)HoverEvent.hoverEvent((HoverEvent.Action)HoverEvent.Action.SHOW_TEXT, (Object)Component.text((String)"Click to receive fish")));
                        fishBuilder.clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.RUN_COMMAND, (String)("/emf admin fish " + rarity.getId() + " " + fish.getName().replace(" ", "_"))));
                        builder.append((ComponentBuilder)fishBuilder);
                    }
                    sender.sendMessage((Component)builder.build());
                    break;
                }
                case "rarities": {
                    TextComponent.Builder builder = Component.text();
                    for (Rarity rarity : FishManager.getInstance().getRarityMap().values()) {
                        TextComponent.Builder rarityBuilder = Component.text();
                        EMFSingleMessage message = EMFSingleMessage.fromString("<gray>[</gray>{rarity}<gray>]</gray>");
                        message.setVariable("{rarity}", rarity.getDisplayName());
                        rarityBuilder.append(message.getComponentMessage());
                        rarityBuilder.hoverEvent((HoverEventSource)HoverEvent.hoverEvent((HoverEvent.Action)HoverEvent.Action.SHOW_TEXT, (Object)EMFSingleMessage.fromString("Click to view " + rarity.getId() + " fish.").getComponentMessage()));
                        rarityBuilder.clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.RUN_COMMAND, (String)("/emf admin list fish " + rarity.getId())));
                        builder.append((ComponentBuilder)rarityBuilder);
                    }
                    sender.sendMessage((Component)builder.build());
                    break;
                }
                case "requirementTypes": {
                    this.listRequirementTypes((Audience)sender);
                    break;
                }
                case "rewardTypes": {
                    this.listRewardTypes((Audience)sender);
                    break;
                }
                case "itemAddons": {
                    this.listItemAddons((Audience)sender);
                }
            }
        }, new ExecutorType[0]);
    }

    private CommandAPICommand getCustomRod() {
        HELP_MESSAGE.addUsage("admin custom-rod", ConfigMessage.HELP_ADMIN_CUSTOMROD::getMessage);
        return (CommandAPICommand)((CommandAPICommand)new CommandAPICommand("custom-rod").withArguments(new Argument[]{CustomRodArgument.create(), (Argument)new EntitySelectorArgument.ManyPlayers("targets").setOptional(true)})).executes((sender, args) -> {
            List players = (List)args.getOptional("targets").orElseGet(() -> {
                if (sender instanceof Player) {
                    Player p = (Player)sender;
                    return List.of(p);
                }
                return null;
            });
            if (players == null) {
                ConfigMessage.ADMIN_CANT_BE_CONSOLE.getMessage().send((Audience)sender);
                return;
            }
            CustomRod rod = Objects.requireNonNull((CustomRod)args.getUnchecked("customRod"));
            ItemStack rodItem = rod.create();
            for (Player player : players) {
                FishUtils.giveItems(List.of(rodItem), player);
            }
            EMFMessage giveMessage = ConfigMessage.ADMIN_CUSTOM_ROD_GIVEN.getMessage();
            giveMessage.setVariable("{player}", this.getPlayersVariable(args.getRaw("targets"), players));
            giveMessage.send((Audience)sender);
        }, new ExecutorType[0]);
    }

    private CommandAPICommand getBait() {
        HELP_MESSAGE.addUsage("admin bait", ConfigMessage.HELP_ADMIN_BAIT::getMessage);
        return (CommandAPICommand)((CommandAPICommand)new CommandAPICommand("bait").withArguments(new Argument[]{BaitArgument.create(), (Argument)new IntegerArgument("quantity", 1).setOptional(true), (Argument)new EntitySelectorArgument.ManyPlayers("targets").setOptional(true)})).executes((sender, args) -> {
            BaitHandler bait = Objects.requireNonNull((BaitHandler)args.getUnchecked("bait"));
            int quantity = (Integer)args.getOptional("quantity").orElse(1);
            List targets = (List)args.getOptional("targets").orElseGet(() -> {
                if (sender instanceof Player) {
                    Player p = (Player)sender;
                    return List.of(p);
                }
                return null;
            });
            if (targets == null) {
                ConfigMessage.ADMIN_CANT_BE_CONSOLE.getMessage().send((Audience)sender);
                return;
            }
            for (Player target : targets) {
                ItemStack baitItem = bait.create((OfflinePlayer)target);
                baitItem.setAmount(quantity);
                FishUtils.giveItems(List.of(baitItem), target);
            }
            EMFMessage message = ConfigMessage.ADMIN_GIVE_PLAYER_BAIT.getMessage();
            message.setVariable("{player}", this.getPlayersVariable(args.getRaw("targets"), targets));
            message.setBait(bait.getId());
            message.send((Audience)sender);
        }, new ExecutorType[0]);
    }

    private CommandAPICommand getClearBaits() {
        HELP_MESSAGE.addUsage("admin clearbaits", ConfigMessage.HELP_ADMIN_CLEARBAITS::getMessage);
        return (CommandAPICommand)((CommandAPICommand)new CommandAPICommand("clearbaits").withArguments(new Argument[]{(Argument)ArgumentHelper.getPlayerArgument("target").setOptional(true)})).executes((sender, args) -> {
            Player player = (Player)args.getOptional("target").orElseGet(() -> {
                if (sender instanceof Player) {
                    Player p = (Player)sender;
                    return p;
                }
                return null;
            });
            if (player == null) {
                ConfigMessage.ADMIN_CANT_BE_CONSOLE.getMessage().send((Audience)sender);
                return;
            }
            if (player.getInventory().getItemInMainHand().getType() != Material.FISHING_ROD) {
                ConfigMessage.ADMIN_NOT_HOLDING_ROD.getMessage().send((Audience)player);
                return;
            }
            ItemStack fishingRod = player.getInventory().getItemInMainHand();
            if (!BaitNBTManager.isBaitedRod(fishingRod)) {
                ConfigMessage.NO_BAITS.getMessage().send((Audience)player);
                return;
            }
            int totalDeleted = BaitNBTManager.deleteAllBaits(fishingRod);
            if (totalDeleted > 0) {
                fishingRod.editMeta(meta -> meta.lore(BaitNBTManager.deleteOldLore(fishingRod)));
            }
            EMFMessage message = ConfigMessage.BAITS_CLEARED.getMessage();
            message.setAmount(Integer.toString(totalDeleted));
            message.send((Audience)player);
        }, new ExecutorType[0]);
    }

    private CommandAPICommand getReload() {
        HELP_MESSAGE.addUsage("admin reload", ConfigMessage.HELP_ADMIN_RELOAD::getMessage);
        return (CommandAPICommand)new CommandAPICommand("reload").executes(info -> EvenMoreFish.getInstance().reload((CommandSender)info.sender()), new ExecutorType[0]);
    }

    private void listRewardTypes(@NotNull Audience audience) {
        TextComponent.Builder builder = Component.text();
        EMFMessage listMessage = ConfigMessage.ADMIN_LIST_ADDONS.getMessage();
        listMessage.setVariable("{addon-type}", RewardType.class.getSimpleName());
        builder.append(listMessage.getComponentMessage());
        RewardType.getLoadedTypes().forEach((string, rewardType) -> {
            Component show = EMFSingleMessage.fromString("Author: " + rewardType.getAuthor() + "\nRegistered Plugin: " + rewardType.getPlugin().getName()).getComponentMessage();
            TextComponent.Builder typeBuilder = Component.text().content(rewardType.getIdentifier());
            typeBuilder.hoverEvent((HoverEventSource)HoverEvent.hoverEvent((HoverEvent.Action)HoverEvent.Action.SHOW_TEXT, (Object)show));
            ((TextComponent.Builder)builder.append((ComponentBuilder)typeBuilder)).append((Component)Component.text((String)", "));
        });
        audience.sendMessage((Component)builder.build());
    }

    private void listRequirementTypes(@NotNull Audience audience) {
        TextComponent.Builder builder = Component.text();
        EMFMessage listMessage = ConfigMessage.ADMIN_LIST_ADDONS.getMessage();
        listMessage.setVariable("{addon-type}", RequirementType.class.getSimpleName());
        builder.append(listMessage.getComponentMessage());
        RequirementType.getLoadedTypes().forEach((string, requirementType) -> {
            Component show = EMFSingleMessage.fromString("Author: " + requirementType.getAuthor() + "\nRegistered Plugin: " + requirementType.getPlugin().getName()).getComponentMessage();
            TextComponent.Builder typeBuilder = Component.text().content(requirementType.getIdentifier());
            typeBuilder.hoverEvent((HoverEventSource)HoverEvent.hoverEvent((HoverEvent.Action)HoverEvent.Action.SHOW_TEXT, (Object)show));
            ((TextComponent.Builder)builder.append((ComponentBuilder)typeBuilder)).append((Component)Component.text((String)", "));
        });
        audience.sendMessage((Component)builder.build());
    }

    private void listItemAddons(@NotNull Audience audience) {
        TextComponent.Builder builder = Component.text();
        EMFMessage listMessage = ConfigMessage.ADMIN_LIST_ADDONS.getMessage();
        listMessage.setVariable("{addon-type}", ItemAddon.class.getSimpleName());
        builder.append(listMessage.getComponentMessage());
        ItemAddon.getLoadedAddons().forEach((string, itemAddon) -> {
            Component show = EMFSingleMessage.fromString("Author: " + itemAddon.getAuthor()).getComponentMessage();
            TextComponent.Builder typeBuilder = Component.text().content(itemAddon.getIdentifier());
            typeBuilder.hoverEvent((HoverEventSource)HoverEvent.hoverEvent((HoverEvent.Action)HoverEvent.Action.SHOW_TEXT, (Object)show));
            ((TextComponent.Builder)builder.append((ComponentBuilder)typeBuilder)).append((Component)Component.text((String)", "));
        });
        audience.sendMessage((Component)builder.build());
    }

    private CommandAPICommand getVersion() {
        HELP_MESSAGE.addUsage("admin version", ConfigMessage.HELP_ADMIN_VERSION::getMessage);
        return (CommandAPICommand)new CommandAPICommand("version").executes(info -> {
            int fishCount = FishManager.getInstance().getRarityMap().values().stream().mapToInt(rarity -> rarity.getFishList().size()).sum();
            String databaseEngine = "N/A";
            String databaseType = "N/A";
            Database database = EvenMoreFish.getInstance().getPluginDataManager().getDatabase();
            if (database != null) {
                databaseEngine = database.getDatabaseVersion();
                databaseType = database.getType();
            }
            String msgString = "{prefix} EvenMoreFish by Oheers {version} \n{prefix} Feature Branch: {branch} \n{prefix} Feature Build/Date: {build-date} \n{prefix} MCV: {mcv} \n{prefix} SSV: {ssv} \n{prefix} Online: {online} \n{prefix} Loaded Rarities({rarities}) Fish({fish}) Baits({baits}) Competitions({competitions}) \n{prefix} Database Engine: {engine} \n{prefix} Database Type: {type} \n";
            EMFSingleMessage message = EMFSingleMessage.fromString("{prefix} EvenMoreFish by Oheers {version} \n{prefix} Feature Branch: {branch} \n{prefix} Feature Build/Date: {build-date} \n{prefix} MCV: {mcv} \n{prefix} SSV: {ssv} \n{prefix} Online: {online} \n{prefix} Loaded Rarities({rarities}) Fish({fish}) Baits({baits}) Competitions({competitions}) \n{prefix} Database Engine: {engine} \n{prefix} Database Type: {type} \n");
            message.setVariable("{prefix}", PrefixType.DEFAULT.getPrefix());
            message.setVariable("{version}", EvenMoreFish.getInstance().getPluginMeta().getVersion());
            message.setVariable("{branch}", this.getFeatureBranchName());
            message.setVariable("{build-date}", this.getFeatureBranchBuildOrDate());
            message.setVariable("{mcv}", Bukkit.getServer().getVersion());
            message.setVariable("{ssv}", Bukkit.getServer().getBukkitVersion());
            message.setVariable("{online}", String.valueOf(Bukkit.getServer().getOnlineMode()));
            message.setVariable("{rarities}", String.valueOf(FishManager.getInstance().getRarityMap().size()));
            message.setVariable("{fish}", String.valueOf(fishCount));
            message.setVariable("{baits}", String.valueOf(BaitManager.getInstance().getItemMap().size()));
            message.setVariable("{competitions}", String.valueOf(EvenMoreFish.getInstance().getCompetitionQueue().getSize()));
            message.setVariable("{engine}", databaseEngine);
            message.setVariable("{type}", databaseType);
            message.send((Audience)info.sender());
        }, new ExecutorType[0]);
    }

    private String getFeatureBranchName() {
        return ManifestUtil.getAttributeFromManifest(Attributes.Name.IMPLEMENTATION_TITLE.toString(), "main");
    }

    private String getFeatureBranchBuildOrDate() {
        return ManifestUtil.getAttributeFromManifest(Attributes.Name.IMPLEMENTATION_VERSION.toString(), "");
    }

    private CommandAPICommand getRewardTypes() {
        HELP_MESSAGE.addUsage("admin rewardtypes", ConfigMessage.HELP_ADMIN_REWARDTYPES::getMessage);
        return (CommandAPICommand)new CommandAPICommand("rewardtypes").executes(info -> {
            TextComponent.Builder builder = Component.text();
            builder.append(ConfigMessage.ADMIN_LIST_REWARD_TYPES.getMessage().getComponentMessage());
            RewardType.getLoadedTypes().forEach((string, rewardType) -> {
                Component show = EMFSingleMessage.fromString("Author: " + rewardType.getAuthor() + "\nRegistered Plugin: " + rewardType.getPlugin().getName()).getComponentMessage();
                TextComponent.Builder typeBuilder = Component.text().content(rewardType.getIdentifier());
                typeBuilder.hoverEvent((HoverEventSource)HoverEvent.hoverEvent((HoverEvent.Action)HoverEvent.Action.SHOW_TEXT, (Object)show));
                ((TextComponent.Builder)builder.append((ComponentBuilder)typeBuilder)).append((Component)Component.text((String)", "));
            });
            ((CommandSender)info.sender()).sendMessage((Component)builder.build());
        }, new ExecutorType[0]);
    }

    private CommandAPICommand getMigrate() {
        HELP_MESSAGE.addUsage("admin migrate", ConfigMessage.HELP_ADMIN_MIGRATE::getMessage);
        return (CommandAPICommand)new CommandAPICommand("migrate").executes(info -> {
            if (!DatabaseUtil.isDatabaseOnline()) {
                EMFSingleMessage.fromString("You cannot run migrations when the database is disabled. Please set database.enabled: true. And restart the server.").send((Audience)info.sender());
                return;
            }
            EvenMoreFish.getScheduler().runTaskAsynchronously(() -> EvenMoreFish.getInstance().getPluginDataManager().getDatabase().getMigrationManager().migrateLegacy((CommandSender)info.sender()));
        }, new ExecutorType[0]);
    }

    private CommandAPICommand getRawItem() {
        HELP_MESSAGE.addUsage("admin rawItem", ConfigMessage.HELP_ADMIN_RAWITEM::getMessage);
        return (CommandAPICommand)new CommandAPICommand("rawItem").executesPlayer(info -> {
            ItemStack handItem = ((Player)info.sender()).getInventory().getItemInMainHand();
            if (handItem.isEmpty()) {
                return;
            }
            String handItemNbt = NBT.itemStackToNBT(handItem).toString();
            YamlDocument document = new ConfigBase().getConfig();
            document.set("rawItem", (Object)handItemNbt);
            handItemNbt = document.dump().replaceFirst("rawItem: ", "");
            TextComponent.Builder builder = Component.text().content(handItemNbt);
            builder.hoverEvent((HoverEventSource)HoverEvent.hoverEvent((HoverEvent.Action)HoverEvent.Action.SHOW_TEXT, (Object)Component.text((String)"Click to copy to clipboard.")));
            builder.clickEvent(ClickEvent.clickEvent((ClickEvent.Action)ClickEvent.Action.COPY_TO_CLIPBOARD, (String)handItemNbt));
            ((Player)info.sender()).sendMessage((Component)builder.build());
        });
    }

    private CommandAPICommand getHelp() {
        HELP_MESSAGE.addUsage("admin help", ConfigMessage.HELP_GENERAL_HELP::getMessage);
        return (CommandAPICommand)new CommandAPICommand("help").executes(info -> this.sendHelpMessage((CommandSender)info.sender()), new ExecutorType[0]);
    }

    private CommandAPICommand getCompetition() {
        HELP_MESSAGE.addUsage("admin competition", ConfigMessage.HELP_ADMIN_COMPETITION::getMessage);
        return (CommandAPICommand)new CommandAPICommand("competition").withSubcommands(new CommandAPICommand[]{this.getCompetitionStart(), this.getCompetitionEnd(), this.getCompetitionTest()});
    }

    private CommandAPICommand getCompetitionStart() {
        return (CommandAPICommand)((CommandAPICommand)new CommandAPICommand("start").withArguments(new Argument[]{ArgumentHelper.getAsyncStringsArgument("competitionId", info -> (String[])EvenMoreFish.getInstance().getCompetitionQueue().getItemMap().keySet().toArray(String[]::new)), (Argument)new IntegerArgument("duration", 1).setOptional(true)})).executes((sender, arguments) -> {
            String id = Objects.requireNonNull((String)arguments.getUnchecked("competitionId"));
            Integer duration = (Integer)arguments.getUnchecked("duration");
            if (Competition.isActive()) {
                ConfigMessage.COMPETITION_ALREADY_RUNNING.getMessage().send((Audience)sender);
                return;
            }
            CompetitionFile file = (CompetitionFile)EvenMoreFish.getInstance().getCompetitionQueue().getItemMap().get(id);
            if (file == null) {
                ConfigMessage.INVALID_COMPETITION_ID.getMessage().send((Audience)sender);
                return;
            }
            Competition competition = new Competition(file);
            competition.setAdminStarted(true);
            if (duration != null) {
                competition.setMaxDuration(duration);
            }
            competition.begin();
        }, new ExecutorType[0]);
    }

    private CommandAPICommand getCompetitionEnd() {
        return (CommandAPICommand)new CommandAPICommand("end").executes(info -> {
            Competition active = Competition.getCurrentlyActive();
            if (active != null) {
                active.end(false);
                return;
            }
            ConfigMessage.NO_COMPETITION_RUNNING.getMessage().send((Audience)info.sender());
        }, new ExecutorType[0]);
    }

    private CommandAPICommand getCompetitionTest() {
        return (CommandAPICommand)((CommandAPICommand)new CommandAPICommand("test").withArguments(new Argument[]{(Argument)new IntegerArgument("duration", 1).setOptional(true), (Argument)CompetitionTypeArgument.create().setOptional(true)})).executes((sender, args) -> {
            if (Competition.isActive()) {
                ConfigMessage.COMPETITION_ALREADY_RUNNING.getMessage().send((Audience)sender);
                return;
            }
            int duration = (Integer)args.getOptional("duration").orElse(60);
            CompetitionType type = (CompetitionType)((Object)((Object)args.getOptional("competitionType").orElse((Object)CompetitionType.LARGEST_FISH)));
            CompetitionFile file = new CompetitionFile("adminTest", type, duration);
            Competition competition = new Competition(file);
            competition.setAdminStarted(true);
            competition.begin();
        }, new ExecutorType[0]);
    }

    @NotNull
    private String getPlayersVariable(@Nullable String raw, @NotNull List<Player> players) {
        if ("@a".equals(raw)) {
            return "All Players";
        }
        return String.join((CharSequence)", ", players.stream().map(Player::getName).toList());
    }
}

