/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.competition;

import com.oheers.fish.FishUtils;
import com.oheers.fish.competition.CompetitionType;
import com.oheers.fish.config.MainConfig;
import com.oheers.fish.messages.ConfigMessage;
import com.oheers.fish.messages.abstracted.EMFMessage;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class Bar {
    BossBar bar;
    private boolean shouldShow = true;
    EMFMessage prefix;

    public Bar() {
        this.createBar();
    }

    public void setShouldShow(boolean shouldShow) {
        this.shouldShow = shouldShow;
    }

    public void timerUpdate(long timeLeft, long totalTime) {
        this.setTitle(timeLeft);
        this.setProgress(timeLeft, totalTime);
    }

    public void setProgress(long timeLeft, long totalTime) {
        float progress = (float)timeLeft / (float)totalTime;
        if (progress < 0.0f) {
            progress = 0.0f;
        } else if (progress > 1.0f) {
            progress = 1.0f;
        }
        this.bar.progress(progress);
    }

    public void setPrefix(EMFMessage prefix, CompetitionType type) {
        prefix.setVariable("{type}", type.getBarPrefix());
        this.prefix = prefix;
    }

    public void setColour(BossBar.Color colour) {
        this.bar.color(colour);
    }

    public void setTitle(long timeLeft) {
        EMFMessage layoutMessage = ConfigMessage.BAR_LAYOUT.getMessage();
        layoutMessage.setVariable("{prefix}", this.prefix);
        layoutMessage.setVariable("{time-formatted}", FishUtils.timeFormat(timeLeft));
        layoutMessage.setVariable("{remaining}", ConfigMessage.BAR_REMAINING.getMessage());
        this.bar.name(layoutMessage.getComponentMessage());
    }

    public void show() {
        if (!this.shouldShow) {
            return;
        }
        Bukkit.getOnlinePlayers().forEach(this::addPlayer);
    }

    public void hide() {
        Bukkit.getOnlinePlayers().forEach(this::removePlayer);
    }

    public void createBar() {
        BossBar.Overlay barStyle = MainConfig.getInstance().getBarStyle();
        this.bar = BossBar.bossBar((Component)Component.text((String)"EMF BossBar"), (float)1.0f, (BossBar.Color)BossBar.Color.WHITE, (BossBar.Overlay)barStyle);
    }

    public void removeAllPlayers() {
        this.bar.viewers().forEach(viewer -> {
            if (viewer instanceof Audience) {
                Audience audience = (Audience)viewer;
                this.bar.removeViewer(audience);
            }
        });
    }

    private void addAllPlayers() {
        Bukkit.getOnlinePlayers().forEach(arg_0 -> ((BossBar)this.bar).addViewer(arg_0));
    }

    public void addPlayer(@NotNull Player player) {
        if (!this.shouldShow) {
            return;
        }
        this.bar.addViewer((Audience)player);
    }

    public void removePlayer(@NotNull Player player) {
        this.bar.removeViewer((Audience)player);
    }
}

